/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.tasks;

import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchiesInfoI;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageTaskI;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageTaskQueue;
import crazydev.iccube.cluster.node.context.N_CancellingContext;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import crazydev.iccube.request.OlapServerCancelledRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class N_FactPageTasks {
    private final ReentrantLock queuesLOCK = new ReentrantLock();
    private final Condition queuesFullCondition = this.queuesLOCK.newCondition();
    private final OlapEngineComponentConfiguration configuration;
    private final N_FactPage page;
    private final N_FactPageTaskQueue[] queues;
    private final boolean[] availableQueues;
    private final int[] restoredRowOffsets;
    private final int[] rowOffsets;

    public N_FactPageTasks(OlapEngineComponentConfiguration configuration, S_SchemaDef schemaDef, N_FactPage page) {
        this.configuration = configuration;
        this.page = page;
        this.queues = new N_FactPageTaskQueue[schemaDef.getIndexingHierarchyArraySize() + 1];
        this.availableQueues = new boolean[this.queues.length];
        this.restoredRowOffsets = new int[this.queues.length];
        this.rowOffsets = new int[this.queues.length];
    }

    public void restore(int nextRowId) {
        this.queuesLOCK.lock();
        try {
            for (int ii = 0; ii < this.restoredRowOffsets.length; ++ii) {
                this.restoredRowOffsets[ii] = nextRowId;
            }
        }
        finally {
            this.queuesLOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onFactsProcessingCompleted() {
        this.queuesLOCK.lock();
        try {
            N_FactPageTaskQueue queue;
            int queueIdx;
            int nextRowId = -1;
            for (queueIdx = 0; queueIdx < this.queues.length; ++queueIdx) {
                queue = this.queues[queueIdx];
                if (queue == null || queue.size() <= 0) continue;
                throw new RuntimeException("internal error: facts [" + this.page.getNameForStats() + "] unexpected remaining task(s) [" + queue.size() + "][" + queueIdx + "]");
            }
            for (queueIdx = 0; queueIdx < this.queues.length; ++queueIdx) {
                queue = this.queues[queueIdx];
                if (queue == null) continue;
                if (nextRowId == -1) {
                    nextRowId = this.rowOffsets[queueIdx];
                    continue;
                }
                if (this.rowOffsets[queueIdx] == nextRowId) continue;
                throw new RuntimeException("internal error: facts [" + this.page.getNameForStats() + "] unexpected row count [" + nextRowId + "][" + this.rowOffsets[queueIdx] + "]");
            }
            if (nextRowId == -1) {
                nextRowId = 0;
            }
            int n = nextRowId;
            return n;
        }
        finally {
            this.queuesLOCK.unlock();
        }
    }

    public void addBatch(N_CancellingContext context, @Nullable OlapSchemaFactsBuilderStats stats, N_FactPageBatchHierarchiesInfoI batch) {
        List<N_FactPageTaskI> tasks = batch.createTasks(this.page);
        this.addTasks(context, stats, tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTasks(N_CancellingContext context, @Nullable OlapSchemaFactsBuilderStats stats, List<N_FactPageTaskI> tasks) {
        if (this.queuesLOCK.isLocked() && stats != null) {
            stats.onPageLock();
        }
        long startNS = System.nanoTime();
        this.queuesLOCK.lock();
        try {
            boolean oneQueueFull;
            if (stats != null) {
                stats.onPageLockNS(System.nanoTime() - startNS);
            }
            do {
                oneQueueFull = false;
                for (N_FactPageTaskQueue queue : this.queues) {
                    if (queue == null || !queue.isFull()) continue;
                    oneQueueFull = true;
                    break;
                }
                if (!oneQueueFull) continue;
                try {
                    this.queuesFullCondition.await();
                }
                catch (InterruptedException ex) {
                    boolean cancelling = context.isCancelling();
                    OlapLoggers.BUILDER.info((Object)("[facts] addTasks interrupted [cancelling:" + cancelling + "]"), (Throwable)ex);
                    if (!cancelling) continue;
                    throw new OlapServerCancelledRequestException("[facts] addTasks interrupted");
                }
            } while (oneQueueFull);
            int taskCount = tasks.size();
            for (int taskIdx = 0; taskIdx < taskCount; ++taskIdx) {
                N_FactPageTaskI task = tasks.get(taskIdx);
                int hierarchyIdx = task.getHierarchyIdx();
                N_FactPageTaskQueue queue = this.queues[hierarchyIdx];
                if (queue == null) {
                    this.queues[hierarchyIdx] = queue = new N_FactPageTaskQueue(this.configuration, hierarchyIdx);
                    this.rowOffsets[hierarchyIdx] = this.restoredRowOffsets[hierarchyIdx];
                    this.availableQueues[hierarchyIdx] = true;
                }
                queue.offerLast(task);
            }
        }
        finally {
            this.queuesLOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(N_CancellingContext context, @Nullable OlapSchemaFactsBuilderStats stats) {
        while (true) {
            ArrayList<N_FactPageTaskI> tasks = null;
            int taskQueueIdx = 0;
            int taskQueueRowOffset = 0;
            if (this.queuesLOCK.isLocked() && stats != null) {
                stats.onPageLock();
            }
            long startNS = System.nanoTime();
            this.queuesLOCK.lock();
            try {
                if (stats != null) {
                    stats.onPageLockNS(System.nanoTime() - startNS);
                }
                for (int queueIdx = 0; queueIdx < this.availableQueues.length; ++queueIdx) {
                    if (!this.availableQueues[queueIdx]) continue;
                    N_FactPageTaskQueue queue = this.queues[queueIdx];
                    N_FactPageTaskI task = null;
                    while ((task = queue.pollFirst()) != null) {
                        if (tasks == null) {
                            tasks = new ArrayList<N_FactPageTaskI>();
                        }
                        tasks.add(task);
                    }
                    if (tasks == null) continue;
                    this.queuesFullCondition.signalAll();
                    taskQueueIdx = queueIdx;
                    taskQueueRowOffset = this.rowOffsets[queueIdx];
                    this.availableQueues[queueIdx] = false;
                    break;
                }
            }
            finally {
                this.queuesLOCK.unlock();
            }
            if (tasks == null) return;
            int processedRowCount = 0;
            int taskCount = tasks.size();
            for (int taskIdx = 0; taskIdx < taskCount; ++taskIdx) {
                N_FactPageTaskI task = (N_FactPageTaskI)tasks.get(taskIdx);
                processedRowCount += task.process(context, taskQueueRowOffset + processedRowCount);
            }
            if (this.queuesLOCK.isLocked() && stats != null) {
                stats.onPageLock();
            }
            startNS = System.nanoTime();
            this.queuesLOCK.lock();
            try {
                if (stats != null) {
                    stats.onPageLockNS(System.nanoTime() - startNS);
                }
                int n = taskQueueIdx;
                this.rowOffsets[n] = this.rowOffsets[n] + processedRowCount;
                this.availableQueues[taskQueueIdx] = true;
                continue;
            }
            finally {
                this.queuesLOCK.unlock();
                continue;
            }
            break;
        }
    }
}

