/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.tasks;

import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchiesInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchyInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalNoPartitions;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartitions;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class N_FactPageBatchInfoNP
extends N_FactPageBatchInfo {
    private final N_FactPageBatchHierarchyInfo[] hierarchyInfos;
    private final List<Object[]> measures;
    protected S_FactPageRef factsPageRef;
    private int nextRowIndex;

    public N_FactPageBatchInfoNP(int batchMaxRowCount, List<Integer> indexingHierarchyIndices, OlapMeasureMember[] measureMembers, int hierarchyCount) {
        super(batchMaxRowCount, indexingHierarchyIndices, measureMembers);
        this.hierarchyInfos = new N_FactPageBatchHierarchyInfo[hierarchyCount];
        this.measures = new ArrayList<Object[]>();
    }

    @Override
    public boolean hasData() {
        return !this.measures.isEmpty();
    }

    @Override
    public int onRowStarted(@Nullable Object levelPartition) {
        return this.nextRowIndex;
    }

    @Override
    public void clearMember(@Nullable Object levelPartition, OlapDimension dimension, int rowIndex) {
        List<OlapHierarchy> hierarchies = dimension.getHierarchies();
        for (OlapHierarchy hierarchy : hierarchies) {
            N_FactPageBatchHierarchyInfo info;
            int hierarchyIndex = hierarchy.getTupleDimensionalityIndex();
            if (hierarchyIndex >= this.hierarchyInfos.length || (info = this.hierarchyInfos[hierarchyIndex]) == null) continue;
            info.clearRow(rowIndex);
        }
    }

    @Override
    public void addMember(IOlapBuilderDataViewLinksDef links, @Nullable Object levelPartition, OlapMember member, int rowIndex) {
        int hierarchyIndex = member.getTupleDimensionalityIndex();
        int levelIndex = member.getLevel().getDepth();
        N_FactPageBatchHierarchyInfo hierarchy = this.computeHierarchyIfAbsent(hierarchyIndex);
        if (levelIndex != -1) {
            hierarchy.addLevel(levelIndex);
        }
        hierarchy.addRow(member, rowIndex);
    }

    @Override
    public void addMeasures(@Nullable Object levelPartition, Object[] measures, int rowIndex) {
        this.measures.add(measures);
    }

    @Override
    public void onRowAdded(@Nullable Object levelPartition) {
        ++this.nextRowIndex;
    }

    @Override
    public void resolvePartitions(OlapBuilderFactContext context, M_FactsLocalPartitions partitions) {
        M_FactsLocalNoPartitions partitions_ = (M_FactsLocalNoPartitions)partitions;
        M_FactsLocalPartition partition = partitions_.getOrCreatePartition(context, null);
        this.factsPageRef = partition.getFactsPageRef();
    }

    @Override
    public void addFactsRows(@Nullable OlapSchemaFactsBuilderStats stats, N_BuildSchemaContext schemaContext, N_BuildFactContext factsContext, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, OlapFactRowAggregationType rowAggregationType) {
        N_Schema schema = schemaContext.getSchema();
        N_FactPage factPage = schema.getFactPage(factsContext, cubeRef, measureGroupRef, this.factsPageRef);
        N_FactPageBatchHierarchiesInfo info = new N_FactPageBatchHierarchiesInfo(this.indexingHierarchyIndices, this.factsPageRef, this.hierarchyInfos, this.measureMembers, this.measures);
        factPage.addFactsRows(schemaContext, stats, rowAggregationType, info);
    }

    private N_FactPageBatchHierarchyInfo computeHierarchyIfAbsent(int hierarchyIndex) {
        N_FactPageBatchHierarchyInfo hierarchy = this.hierarchyInfos[hierarchyIndex];
        if (hierarchy == null) {
            this.hierarchyInfos[hierarchyIndex] = hierarchy = new N_FactPageBatchHierarchyInfo(hierarchyIndex, this.batchMaxRowCount);
        }
        return hierarchy;
    }
}

