/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.tasks;

import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactBuilder;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchiesInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchHierarchyInfo;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalLevelPartitions;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartitions;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class N_FactPageBatchInfoLP
extends N_FactPageBatchInfo {
    private final OlapDimension partitioningDimension;
    private final int partitioningDimensionIndex;
    private final OlapLevel partitioningLevel;
    private final int hierarchyCount;
    private final Map<PartitionKey, PartitionInfo> partitions;

    public N_FactPageBatchInfoLP(int batchMaxRowCount, List<Integer> indexingHierarchyIndices, OlapMeasureMember[] measureMembers, OlapDimension partitioningDimension, int partitioningDimensionIndex, OlapLevel partitioningLevel, int hierarchyCount) {
        super(batchMaxRowCount, indexingHierarchyIndices, measureMembers);
        this.partitioningDimension = partitioningDimension;
        this.partitioningDimensionIndex = partitioningDimensionIndex;
        this.partitioningLevel = partitioningLevel;
        this.hierarchyCount = hierarchyCount;
        this.partitions = new HashMap<PartitionKey, PartitionInfo>();
    }

    @Override
    public boolean hasData() {
        if (!this.partitions.isEmpty()) {
            // empty if block
        }
        for (PartitionInfo partitionInfo : this.partitions.values()) {
            if (!partitionInfo.hasData()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLevelPartitioning() {
        return true;
    }

    @Override
    public int getLevelPartitioningDimensionIndex() {
        return this.partitioningDimensionIndex;
    }

    @Override
    @Nullable
    public Object resolveLevelPartition(OlapBuilderFactBuilder builder, OlapMember[] members) {
        String nameForStats = "n/a";
        int partitionIdx = 0;
        for (int ii = 0; ii < members.length; ++ii) {
            OlapMember member = members[ii];
            if (member.getHierarchy() != this.partitioningLevel.getHierarchy()) continue;
            OlapMember partitionMember = member.getAncestor(this.partitioningLevel);
            if (partitionMember == null) {
                partitionIdx = 0;
                nameForStats = "n/a";
                continue;
            }
            partitionIdx = partitionMember.getDataHandlerIdx();
            nameForStats = partitionMember.getName(OlapNameContext.DEFAULT_VALUES);
        }
        PartitionKey partitionKey = new PartitionKey(nameForStats, partitionIdx);
        PartitionInfo partition = this.partitions.computeIfAbsent(partitionKey, k -> new PartitionInfo(this, partitionKey, this.hierarchyCount));
        return partition;
    }

    @Override
    public int onRowStarted(@Nullable Object levelPartition) {
        PartitionInfo partition = (PartitionInfo)levelPartition;
        return partition.onRowStarted();
    }

    @Override
    public void addMember(IOlapBuilderDataViewLinksDef links, @Nullable Object levelPartition, OlapMember member, int rowIndex) {
        PartitionInfo partition = (PartitionInfo)levelPartition;
        partition.addMember(member, rowIndex);
    }

    @Override
    public void clearMember(@Nullable Object levelPartition, OlapDimension dimension, int rowIndex) {
        PartitionInfo partition = (PartitionInfo)levelPartition;
        partition.clearMember(dimension, rowIndex);
    }

    @Override
    public void addMeasures(@Nullable Object levelPartition, Object[] measures, int rowIndex) {
        PartitionInfo partition = (PartitionInfo)levelPartition;
        partition.addMeasures(measures, rowIndex);
    }

    @Override
    public void onRowAdded(@Nullable Object levelPartition) {
        PartitionInfo partition = (PartitionInfo)levelPartition;
        partition.onRowAdded();
    }

    @Override
    public void resolvePartitions(OlapBuilderFactContext context, M_FactsLocalPartitions partitions) {
        M_FactsLocalLevelPartitions partitions_ = (M_FactsLocalLevelPartitions)partitions;
        for (PartitionInfo partitionInfo : this.partitions.values()) {
            PartitionKey partitionKey = partitionInfo.partitionKey;
            int partitionIdx = partitionKey.partitionIdx;
            String nameForStats = partitionKey.nameForStats;
            M_FactsLocalPartition partition = partitions_.getOrCreatePartition(context, partitionIdx, nameForStats);
            partitionInfo.factsPageRef = partition.getFactsPageRef();
        }
    }

    @Override
    public void addFactsRows(@Nullable OlapSchemaFactsBuilderStats stats, N_BuildSchemaContext schemaContext, N_BuildFactContext factsContext, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, OlapFactRowAggregationType rowAggregationType) {
        N_Schema schema = schemaContext.getSchema();
        for (PartitionInfo partitionInfo : this.partitions.values()) {
            N_FactPage factPage = schema.getFactPage(factsContext, cubeRef, measureGroupRef, partitionInfo.factsPageRef);
            N_FactPageBatchHierarchiesInfo info = new N_FactPageBatchHierarchiesInfo(this.indexingHierarchyIndices, partitionInfo.factsPageRef, partitionInfo.hierarchyInfos, this.measureMembers, partitionInfo.measures);
            factPage.addFactsRows(schemaContext, stats, rowAggregationType, info);
        }
    }

    class PartitionInfo {
        final PartitionKey partitionKey;
        final N_FactPageBatchHierarchyInfo[] hierarchyInfos;
        final List<Object[]> measures;
        int nextRowIndex;
        S_FactPageRef factsPageRef;
        final /* synthetic */ N_FactPageBatchInfoLP this$0;

        PartitionInfo(N_FactPageBatchInfoLP this$0, PartitionKey partitionKey, int hierarchyCount) {
            N_FactPageBatchInfoLP n_FactPageBatchInfoLP = this$0;
            Objects.requireNonNull(n_FactPageBatchInfoLP);
            this.this$0 = n_FactPageBatchInfoLP;
            this.partitionKey = partitionKey;
            this.hierarchyInfos = new N_FactPageBatchHierarchyInfo[hierarchyCount];
            this.measures = new ArrayList<Object[]>();
        }

        boolean hasData() {
            return !this.measures.isEmpty();
        }

        int onRowStarted() {
            return this.nextRowIndex;
        }

        void addMember(OlapMember member, int rowIndex) {
            int hierarchyIndex = member.getTupleDimensionalityIndex();
            int levelIndex = member.getLevel().getDepth();
            N_FactPageBatchHierarchyInfo hierarchy = this.computeHierarchyIfAbsent(hierarchyIndex);
            if (levelIndex != -1) {
                hierarchy.addLevel(levelIndex);
            }
            hierarchy.addRow(member, rowIndex);
        }

        void clearMember(OlapDimension dimension, int rowIndex) {
            List<OlapHierarchy> hierarchies = dimension.getHierarchies();
            for (OlapHierarchy hierarchy : hierarchies) {
                N_FactPageBatchHierarchyInfo info;
                int hierarchyIndex = hierarchy.getTupleDimensionalityIndex();
                if (hierarchyIndex >= this.hierarchyInfos.length || (info = this.hierarchyInfos[hierarchyIndex]) == null) continue;
                info.clearRow(rowIndex);
            }
        }

        void addMeasures(Object[] measures, int rowIndex) {
            this.measures.add(measures);
        }

        void onRowAdded() {
            ++this.nextRowIndex;
        }

        N_FactPageBatchHierarchyInfo computeHierarchyIfAbsent(int hierarchyIndex) {
            N_FactPageBatchHierarchyInfo hierarchy = this.hierarchyInfos[hierarchyIndex];
            if (hierarchy == null) {
                this.hierarchyInfos[hierarchyIndex] = hierarchy = new N_FactPageBatchHierarchyInfo(hierarchyIndex, this.this$0.batchMaxRowCount);
            }
            return hierarchy;
        }
    }

    static class PartitionKey {
        final String nameForStats;
        final int partitionIdx;

        PartitionKey(String nameForStats, int partitionIdx) {
            this.nameForStats = nameForStats;
            this.partitionIdx = partitionIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionKey that = (PartitionKey)o;
            return this.partitionIdx == that.partitionIdx && Objects.equals(this.nameForStats, that.nameForStats);
        }

        public int hashCode() {
            return Objects.hash(this.nameForStats, this.partitionIdx);
        }
    }
}

