/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts;

import crazydev.common.collection.CdAction;
import crazydev.iccube.builder.OlapBuilderBaseToNoBaseMapper;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderFactContext {
    @Nullable
    private final OlapSchemaFactsBuilderStats stats;
    private final S_BuildFactContextRef ref;
    private final OlapBuilderContext context;
    private final String measureGroupName;
    @Nullable
    private final OlapBuilderBaseToNoBaseMapper baseMemberToMember;
    private S_CubeRef cubeRef;
    private S_MeasureGroupRef measureGroupRef;
    private OlapFactRowAggregationType rowAggregationType;

    public OlapBuilderFactContext(OlapBuilderContext context, @Nullable OlapSchemaFactsBuilderStats stats, String measureGroupName) {
        this.stats = stats;
        this.ref = new S_BuildFactContextRef(this);
        this.measureGroupName = measureGroupName;
        this.context = context;
        this.baseMemberToMember = context.getBaseMemberToMemberMap();
    }

    public String __debug() {
        return this.measureGroupName;
    }

    @Nullable
    public OlapSchemaFactsBuilderStats getFullLoadStats() {
        return this.stats;
    }

    public M_LocalCluster getCluster() {
        return this.context.getCluster();
    }

    public S_BuildFactContextRef getClusterContextRef() {
        return this.ref;
    }

    public S_BuildSchemaContextRef getClusterBuildContextRef() {
        S_BuildSchemaContextRef ref = this.context.getClusterContextRef();
        if (ref == null) {
            throw new RuntimeException("internal error: inconsistent build schema setup");
        }
        return ref;
    }

    public void createClusterContext(OlapFactMeasureGroupBaseManager facts) {
        facts.setupClusterBuildFactContext(this);
        this.rowAggregationType = facts.getFactsDefinition().rowFactAggregationType();
        M_LocalCluster cluster = this.context.getCluster();
        S_BuildFactContextInitData data = this.ref.createObjectInitData();
        cluster.createBuildFactContext(data);
    }

    public void forEachNoBaseMembers(OlapMember baseMember, CdAction<OlapMember> action) {
        if (this.baseMemberToMember != null) {
            if (baseMember.getDimension().getHierarchyCount() > 1) {
                this.baseMemberToMember.forEachNoBaseMembers(baseMember, action);
            }
        } else {
            baseMember.getDimension().forEachNoBaseTerminalMember(baseMember, action);
        }
    }

    @Nullable
    public OlapMember getMember(OlapDimension dimension, @Nullable OlapLevel[] levels, Object memberKeyValue) {
        OlapMember lookupMember = null;
        if (levels != null) {
            OlapLevel level;
            for (int i = 0; i < levels.length && (lookupMember = this.lookupMember(level = levels[i], memberKeyValue)) == null; ++i) {
            }
        } else {
            OlapLevel olapLevel;
            List<OlapLevel> allBaseLevels = dimension.getBaseHierarchy().getLevels();
            for (int i = allBaseLevels.size() - 1; i >= 0 && (lookupMember = this.lookupMember(olapLevel = allBaseLevels.get(i), memberKeyValue)) == null; --i) {
            }
        }
        return lookupMember;
    }

    @Nullable
    private OlapMember lookupMember(OlapLevel level, Object memberKeyValue) {
        return level.lookupMemberByKeyValue(memberKeyValue);
    }

    public S_CubeRef getCubeRef() {
        return this.cubeRef;
    }

    public void setCubeRef(S_CubeRef cubeRef) {
        this.cubeRef = cubeRef;
    }

    public S_MeasureGroupRef getMeasureGroupRef() {
        return this.measureGroupRef;
    }

    public void setMeasureGroupRef(S_MeasureGroupRef measureGroupRef) {
        this.measureGroupRef = measureGroupRef;
    }

    public OlapFactRowAggregationType getRowAggregationType() {
        return this.rowAggregationType;
    }

    public void setupPartitionForBackup(M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        this.context.setupPartitionForBackup(measureGroup, partition);
    }
}

