/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts;

import crazydev.common.collection.CdIComparableList;
import crazydev.common.collection.CdMultiColumnValue;
import crazydev.common.exception.programming.CdNotImplementedProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.OlapBuilderAbstractTableListener;
import crazydev.iccube.builder.model.builders.bridge.IOlapBridgeResolver;
import crazydev.iccube.builder.model.builders.bridge.OlapBridgeDef;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactSolveRowError;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTable;
import crazydev.iccube.builder.model.builders.lookuptable.OlapFactsLookupTableKey;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTable;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTableKey;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseFactBuilder
extends OlapBuilderAbstractTableListener {
    protected final OlapSchema schema;
    protected final Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> dimensions;
    protected final OlapDimension[] resolvedDimensions;
    protected final List<Integer> indexingHierarchyIndices;
    protected final OlapBuilderFactContext context;
    protected final OlapNameContext nameContext;
    protected final IOlapBuilderDataViewLinksDef[] resolvedLinks;
    protected final IOlapBridgeResolver[] resolvedBridges;
    protected final boolean[] resolvedBridgesStatus;
    protected final boolean[] resolvedLookupTableStatus;
    protected final OlapLevel[][] resolvedLevels;
    protected final boolean useUnknownMembers;
    @Nullable
    protected final OlapSchemaFactsBuilderStats stats;
    @Nullable
    protected final List<OlapFactsLookupTable> factsLookupTables;

    public OlapBuilderBaseFactBuilder(OlapBuilderContext context, @Nullable OlapSchemaFactsBuilderStats stats, String measureGroupName, Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> dimensions) {
        this.stats = stats;
        this.schema = context.getSchema();
        this.dimensions = dimensions;
        this.resolvedLevels = new OlapLevel[dimensions.size()][];
        this.resolvedLinks = new IOlapBuilderDataViewLinksDef[dimensions.size()];
        this.resolvedBridges = new IOlapBridgeResolver[dimensions.size()];
        this.resolvedBridgesStatus = new boolean[dimensions.size()];
        this.resolvedLookupTableStatus = new boolean[dimensions.size()];
        this.resolvedDimensions = new OlapDimension[dimensions.size()];
        this.useUnknownMembers = context.getSchema().useUnknownMembers();
        this.context = new OlapBuilderFactContext(context, stats, measureGroupName);
        this.nameContext = context.getNameContext();
        HashMap<OlapFactsLookupTableKey, OlapFactsLookupTable> lookupTables = new HashMap<OlapFactsLookupTableKey, OlapFactsLookupTable>();
        int pos = 0;
        for (Map.Entry<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> entry : dimensions.entrySet()) {
            IOlapBridgeResolver bridgeResolver;
            IOlapBuilderDimensionDef dimensionDefinition = entry.getKey();
            IOlapBuilderDataViewLinksDef link = entry.getValue();
            String dimensionName = dimensionDefinition.getName();
            OlapDimension dimension = this.lookupDimension(dimensionName);
            OlapLevel[] level = this.getLevel(link, dimension, (IOlapBuilderHierarchyDef)dimensionDefinition.getValidatedDefaultHierarchy());
            this.resolvedDimensions[pos] = dimension;
            this.resolvedLinks[pos] = link;
            this.resolvedLevels[pos] = level;
            OlapSchema schema = context.getSchema();
            OlapBridgeDef bridgeDef = link.buildBridge();
            this.resolvedBridges[pos] = bridgeResolver = schema.getBridgeResolverForFacts(bridgeDef, dimension);
            boolean bl = this.resolvedBridgesStatus[pos] = bridgeResolver != null;
            if (bridgeDef != null && bridgeResolver == null) {
                IOlapBuilderDataColumnDef factsJoinCol = link.getToColumns().get(0);
                IOlapBuilderDataColumnDef toCol = bridgeDef.getLookupTableTo();
                OlapFactsLookupTable factsLookupTable = OlapBuilderBaseFactBuilder.getOrCreateLookupTable(context, lookupTables, measureGroupName, dimension, bridgeDef, factsJoinCol);
                factsLookupTable.addDimension(dimension, pos, toCol);
                this.resolvedLookupTableStatus[pos] = true;
            }
            ++pos;
        }
        ArrayList arrayList = this.factsLookupTables = !lookupTables.isEmpty() ? new ArrayList(lookupTables.values()) : null;
        if (this.factsLookupTables != null) {
            for (int ii = 0; ii < this.factsLookupTables.size(); ++ii) {
                this.factsLookupTables.get(ii).setResolvedIndex(ii);
            }
        }
        this.indexingHierarchyIndices = new ArrayList<Integer>();
        S_SchemaDef schemaDef = this.schema.getClusterSchemaDef();
        int hierarchyIndexArraySize = schemaDef.getIndexingHierarchyArraySize();
        for (OlapDimension dimension : this.resolvedDimensions) {
            List<OlapHierarchy> hierarchies = dimension.getHierarchies();
            for (OlapHierarchy hierarchy : hierarchies) {
                OlapBuilderBaseFactBuilder.addIndexingHierarchy(this.indexingHierarchyIndices, hierarchy, hierarchyIndexArraySize);
            }
        }
        this.indexingHierarchyIndices.sort(Integer::compareTo);
    }

    private static OlapFactsLookupTable getOrCreateLookupTable(OlapBuilderContext context, Map<OlapFactsLookupTableKey, OlapFactsLookupTable> lookupTables, String measureGroupName, OlapDimension dimension, OlapBridgeDef bridgeDef, IOlapBuilderDataColumnDef factsJoinCol) {
        String tableId = bridgeDef.getLookupTableTableId();
        IOlapBuilderDataColumnDef from = bridgeDef.getLookupTableFrom();
        OlapFactsLookupTableKey factsLookupTableKey = new OlapFactsLookupTableKey(tableId, from, factsJoinCol);
        return lookupTables.computeIfAbsent(factsLookupTableKey, k -> {
            OlapLookupTable lookupTable = context.getSchema().getLookupTable(new OlapLookupTableKey(tableId, from));
            if (lookupTable == null) {
                throw new RuntimeException("unexpected missing lookup table [facts:" + measureGroupName + "] [dimension:" + dimension.getNameX() + "]");
            }
            return new OlapFactsLookupTable(measureGroupName, lookupTable, factsJoinCol);
        });
    }

    protected static void addIndexingHierarchy(List<Integer> indices, OlapHierarchy hierarchy, int hierarchyIndexArraySize) {
        int index = hierarchy.getTupleDimensionalityIndex();
        if (index < hierarchyIndexArraySize) {
            indices.add(index);
        }
    }

    public static OlapMemberKey buildKey(IOlapBuilderDataViewLinksDef link, Object memberKeyValue) {
        List<IOlapBuilderDataColumnDef> keyColumns = link.getDimensionBindingColumn();
        if (keyColumns.size() == 1) {
            OlapBuilderInputType memberKeyType = keyColumns.get(0).getType();
            return OlapMemberKey.create(memberKeyType, (Comparable)memberKeyValue);
        }
        OlapBuilderInputType[] memberKeyTypes = new OlapBuilderInputType[keyColumns.size()];
        for (int idx = 0; idx < keyColumns.size(); ++idx) {
            IOlapBuilderDataColumnDef columnDef = keyColumns.get(idx);
            memberKeyTypes[idx] = columnDef.getType();
        }
        if (memberKeyValue instanceof CdMultiColumnValue) {
            CdMultiColumnValue multiColumnValue = (CdMultiColumnValue)memberKeyValue;
            memberKeyValue = multiColumnValue.getArray();
        }
        return OlapMemberKey.create(memberKeyTypes, memberKeyValue);
    }

    @Nullable
    private static String getLevelName(IOlapBuilderHierarchyDef indexingHierarchy, IOlapBuilderDataViewLinksDef fk) {
        IOlapBuilderHierarchyDef defaultHierarchy = indexingHierarchy;
        IOlapBuilderHierarchyLevelDef level = null;
        if (defaultHierarchy.mightBeIndexingByOneLevel()) {
            level = OlapBuilderBaseFactBuilder.getIndexingFactLevel(defaultHierarchy, fk);
        }
        return level == null ? null : level.getName();
    }

    @Nullable
    public static IOlapBuilderHierarchyLevelDef getIndexingFactLevel(IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef fk) {
        List<IOlapBuilderHierarchyLevelDef> defaultHierarchyLevels = defaultHierarchy.getLevels();
        for (int i = defaultHierarchyLevels.size() - 1; i >= 0; --i) {
            List<IOlapBuilderDataColumnDef> fkFromColumns;
            IOlapBuilderHierarchyLevelDef level = defaultHierarchyLevels.get(i);
            List<IOlapBuilderDataColumnDef> levelKeyColumns = level.getKeyColumns();
            if (!OlapBuilderBaseFactBuilder.isLinkedWith(levelKeyColumns, fkFromColumns = fk.getFromColumns())) continue;
            return level;
        }
        return null;
    }

    public static boolean isLinkedWith(List<IOlapBuilderDataColumnDef> toColumns, List<IOlapBuilderDataColumnDef> fromColumns) {
        if (toColumns.size() != fromColumns.size()) {
            return false;
        }
        for (int i = 0; i < toColumns.size(); ++i) {
            IOlapBuilderDataColumnDef levelColumn = toColumns.get(i);
            if (levelColumn.equals(fromColumns.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLinkedWithRef(List<OlapBuilderDataColumnRef> toColumns, List<IOlapBuilderDataColumnDef> fromColumns) {
        if (toColumns.size() != fromColumns.size()) {
            return false;
        }
        for (int i = 0; i < toColumns.size(); ++i) {
            OlapBuilderDataColumnRef levelColumn = toColumns.get(i);
            if (levelColumn.getName().equals(fromColumns.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public OlapSchemaFactsBuilderStats getStats() {
        return this.stats;
    }

    public abstract OlapFactMeasureGroupBaseManager getFacts();

    public OlapDimension[] getResolvedDimensions() {
        return this.resolvedDimensions;
    }

    public IOlapBuilderDataViewLinksDef[] getResolvedLinks() {
        return this.resolvedLinks;
    }

    public boolean[] getResolvedBridges() {
        return this.resolvedBridgesStatus;
    }

    public boolean[] getResolvedLTs() {
        return this.resolvedLookupTableStatus;
    }

    @Nullable
    private OlapLevel[] getLevel(IOlapBuilderDataViewLinksDef link, OlapDimension dimension, IOlapBuilderHierarchyDef indexingHierarchyDef) {
        if (link.isOldType()) {
            String memberLevelName = OlapBuilderBaseFactBuilder.getLevelName(indexingHierarchyDef, link);
            return this.lookupLevel(dimension, memberLevelName);
        }
        OlapHierarchy indexingHierarchy = dimension.getBaseHierarchy();
        switch (link.getType()) {
            case NOT_MAPPED: {
                return null;
            }
            case LAST_LEVEL: {
                return this.as(indexingHierarchy.getLastLevel());
            }
            case ALL_LEVELS: {
                return null;
            }
            case INTERMEDIATE_LEVEL: 
            case LEVEL_LIST: {
                return this.lookupLevel(dimension, link.getFromLevelNames());
            }
            case RANGE_FROM_TO: {
                return this.as(indexingHierarchy.getLastLevel());
            }
            case MANY_TO_MANY: {
                throw new CdNotImplementedProgrammingException();
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Nullable
    private OlapLevel[] as(@Nullable OlapLevel level) {
        OlapLevel[] olapLevelArray;
        if (level == null) {
            olapLevelArray = null;
        } else {
            OlapLevel[] olapLevelArray2 = new OlapLevel[1];
            olapLevelArray = olapLevelArray2;
            olapLevelArray2[0] = level;
        }
        return olapLevelArray;
    }

    @Override
    public boolean isForFactBuilding() {
        return true;
    }

    protected OlapDimension lookupDimension(String dimensionName) {
        OlapDimension dimension = this.schema.lookupDimensionByName(this.nameContext, dimensionName);
        if (dimension == null) {
            throw new RuntimeException("internal error: dimension [" + dimensionName + "] not found in schema [" + this.schema.getName() + "]");
        }
        return dimension;
    }

    public boolean isAcceptUnresolvedRows() {
        return this.getFactsDefinition().getUnresolvedRowsBehavior().isAcceptUnresolvedRows();
    }

    @Nullable
    protected OlapMember[] lookupMemberByKey(OlapDimension dimension, @Nullable OlapLevel[] indexingLevels, IOlapBuilderDataViewLinksDef link, Object memberKeyValue) {
        if (memberKeyValue instanceof CdIComparableList) {
            return this.lookupMemberByArrayKey(dimension, indexingLevels, link, (CdIComparableList)memberKeyValue);
        }
        return this.lookupMemberBySingleKey(dimension, indexingLevels, link, memberKeyValue);
    }

    @Nullable
    private OlapMember[] lookupMemberBySingleKey(OlapDimension dimension, @Nullable OlapLevel[] indexingLevels, IOlapBuilderDataViewLinksDef link, Object memberKeyValue) {
        OlapMember[] olapMemberArray;
        if (memberKeyValue instanceof CdMultiColumnValue) {
            CdMultiColumnValue multiColumnValue = (CdMultiColumnValue)memberKeyValue;
            memberKeyValue = multiColumnValue.getArray();
        }
        if (dimension.isIndexingByRange()) {
            if (indexingLevels == null || indexingLevels.length != 1) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            return this.lookupMemberBySingleKeyRange(link, dimension, indexingLevels[0], memberKeyValue);
        }
        OlapMember member = this.context.getMember(dimension, indexingLevels, memberKeyValue);
        if (member == null) {
            olapMemberArray = null;
        } else {
            OlapMember[] olapMemberArray2 = new OlapMember[1];
            olapMemberArray = olapMemberArray2;
            olapMemberArray2[0] = member;
        }
        return olapMemberArray;
    }

    @Nullable
    protected OlapMember[] lookupMemberBySingleKeyRange(IOlapBuilderDataViewLinksDef link, OlapDimension dimension, OlapLevel indexingLevel, Object memberKeyValue) {
        return dimension.getBaseHierarchy().lookupMemberByRange(indexingLevel, memberKeyValue);
    }

    private OlapMember[] lookupMemberByArrayKey(OlapDimension dimension, @Nullable OlapLevel[] indexingLevels, IOlapBuilderDataViewLinksDef link, CdIComparableList memberKeyValue) {
        int size = memberKeyValue.size();
        OlapMember[] keys = new OlapMember[size];
        for (int i = 0; i < size; ++i) {
            OlapMember[] key;
            Comparable keyValue = memberKeyValue.get(i);
            OlapMember[] olapMemberArray = key = keyValue == null ? null : this.lookupMemberBySingleKey(dimension, indexingLevels, link, keyValue);
            if (key != null && key.length != 1) {
                throw new CdShouldNotBeHereProgrammingException("Arrays-fact link, start/end not supported");
            }
            if (key == null || key[0] == null) {
                if (this.useUnknownMembers && dimension.getUnknownMemberForFacts() != null) {
                    keys[i] = dimension.getUnknownMemberForFacts();
                    continue;
                }
                throw new CdShouldNotBeHereProgrammingException("Arrays-fact link, null not supported. Key '" + String.valueOf(keyValue) + "' not found in dimension " + dimension.getName(this.nameContext) + "' and unknown member is missing");
            }
            keys[i] = key[0];
        }
        return keys;
    }

    protected abstract String getFactName();

    public abstract IOlapBuilderBaseFactsDef getFactsDefinition();

    @Nullable
    protected Object createMemberKeyFromNativeKeyValue(OlapDimension dimension, @Nullable IOlapBridgeResolver bridgeMap, IOlapBuilderDataViewLinksDef link, @Nullable Comparable nativeKeyValue) throws OlapBuilderFactSolveRowError {
        Comparable value;
        boolean hasUnknownForDimension = this.useUnknownMembers && dimension.getUnknownMemberForFacts() != null;
        List<IOlapBuilderDataColumnDef> keyColumns = link.getToColumns();
        Comparable comparable = value = bridgeMap != null ? bridgeMap.getValues(dimension, nativeKeyValue, hasUnknownForDimension) : nativeKeyValue;
        if (value == null && !hasUnknownForDimension) {
            if (dimension.getFactIndexingHierarchy().getLastLevel().getMemberCount() == 0) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_INDEX_EMPTY_DIMENSION, new Serializable[]{this.getFactName(), dimension.getNameX()});
            }
            this.reportError(dimension, keyColumns);
        }
        return value;
    }

    @Nullable
    protected Object createMemberKey(OlapDimension dimension, @Nullable IOlapBridgeResolver bridgeMap, IOlapBuilderTableRow row, IOlapBuilderDataViewLinksDef link) throws OlapBuilderFactSolveRowError {
        Object key;
        List<IOlapBuilderDataColumnDef> keyColumns = link.getToColumns();
        boolean hasUnknownForDimension = this.useUnknownMembers && dimension.getUnknownMemberForFacts() != null;
        Object rowValue = row.getJavaNativeDataValues(keyColumns);
        Object object = key = bridgeMap == null ? rowValue : bridgeMap.getValues(dimension, (Comparable)rowValue, hasUnknownForDimension);
        if (keyColumns.size() == 1) {
            key = dimension.adaptKeyValue((Comparable)key);
        } else if (key instanceof CdMultiColumnValue) {
            CdMultiColumnValue value = (CdMultiColumnValue)key;
            key = value.getArray();
        }
        if (key == null && !hasUnknownForDimension) {
            if (dimension.getFactIndexingHierarchy().getLastLevel().getMemberCount() == 0) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_INDEX_EMPTY_DIMENSION, new Serializable[]{this.getFactName(), dimension.getNameX()});
            }
            this.reportError(dimension, keyColumns);
        }
        return key;
    }

    private void reportError(OlapDimension dimension, List<IOlapBuilderDataColumnDef> keyColumns) {
        StringBuilder columnNames = new StringBuilder();
        for (int idx = 0; idx < keyColumns.size(); ++idx) {
            IOlapBuilderDataColumnDef columnDef = keyColumns.get(idx);
            columnNames.append(idx != 0 && keyColumns.size() > 1 ? ", " : "").append(columnDef.getName());
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.FOREIGN_KEY_NULL_IN_FACTS, new Serializable[]{dimension.getNameX(), columnNames.toString()});
    }

    @Nullable
    private OlapLevel[] lookupLevel(OlapDimension dimension, @Nullable String levelName) {
        return levelName == null ? null : this.lookupLevel(dimension, Arrays.asList(levelName));
    }

    @Nullable
    private OlapLevel[] lookupLevel(OlapDimension dimension, @Nullable List<String> levelNames) {
        if (levelNames == null || levelNames.isEmpty()) {
            return null;
        }
        OlapHierarchy hierarchy = dimension.getFactIndexingHierarchy();
        ArrayList<OlapLevel> lookupLevels = new ArrayList<OlapLevel>();
        List<OlapLevel> allLevels = hierarchy.getLevels();
        int levelsSize = allLevels.size();
        block0: for (String levelName : levelNames) {
            for (int idx = 0; idx < levelsSize; ++idx) {
                OlapLevel level = allLevels.get(idx);
                if (!OlapCaseInsensitiveName.equals(level.getName(this.nameContext), levelName)) continue;
                lookupLevels.add(level);
                continue block0;
            }
        }
        if (lookupLevels.isEmpty()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Missing level [" + Arrays.toString(levelNames.toArray()) + "] from hierarchy " + hierarchy.getUniqueName(this.nameContext)});
        }
        return lookupLevels.toArray(new OlapLevel[lookupLevels.size()]);
    }
}

