/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.dimension;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdIComparableList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryConnection;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.model.builders.dimension.BaseDimensionBuilder;
import crazydev.iccube.builder.model.builders.dimension.OlapBuilderDimensionBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchyLevel;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.special.time.OlapTimeDimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class OlapBuilderTimeWizardDimensionBuilder<T extends IOlapBuilderHierarchyDef>
extends BaseDimensionBuilder {
    private final OlapTimeDimension olapDimension;
    private final OlapBuilderTimeWizardDimension dimension;
    private LocalDateTime start;
    private LocalDateTime end;

    public OlapBuilderTimeWizardDimensionBuilder(OlapBuilderContext context, OlapDimension olapDimension, OlapBuilderTimeWizardDimension dimension) {
        this.olapDimension = (OlapTimeDimension)olapDimension;
        this.dimension = dimension;
    }

    @Override
    public void onTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        this.start = this.dimension.getFrom();
        this.end = this.dimension.getTo();
    }

    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        IOlapBuilderTableRow row;
        Builder builder = new Builder(this);
        builder.init();
        OlapBuilderDimensionBuilder<OlapBuilderMultiLevelHierarchy> fakeBuilder = new OlapBuilderDimensionBuilder<OlapBuilderMultiLevelHierarchy>(context, this.olapDimension, builder.mlHierarchies, builder.defaultHierarchy);
        TimeWizardTable table = builder.table;
        fakeBuilder.onTableProcessingInit(context, table);
        fakeBuilder.onTableProcessingStarted(context, table);
        List<IOlapBuilderDataColumnDef> allColumns = table.getAllColumns();
        IOlapBuilderTableRowReader<OlapBuilderInMemoryConnection> reader = table.doCreateFullTableRowReader(context, new OlapBuilderConnectionPool(), -1);
        reader.init();
        while ((row = reader.nextRow()) != null) {
            fakeBuilder.onNewRow(context, table, table, allColumns, null, reader.rowNb(), row);
        }
        fakeBuilder.onTableProcessingCompleted(context, table);
        if (this.startedMS != -1L && !context.isIncrLoad()) {
            this.olapDimension.setProcessingElapsedMS(System.currentTimeMillis() - this.startedMS);
        }
    }

    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        context.assertNotCancelling("add-member");
        IOlapBuilderDataColumnDef timeWizardColumn = this.dimension.getTimeWizardColumn();
        if (!this.dimension.useInternalTable() && timeWizardColumn != null) {
            this.forEach(data.getJavaNativeDataValue(timeWizardColumn), date -> {
                if (date == null) {
                    return;
                }
                this.start = this.start == null ? date : CdJodaTimeUtil.min((LocalDateTime)this.start, (LocalDateTime)date);
                LocalDateTime endNextDate = this.toNextDate((LocalDateTime)date);
                this.end = this.end == null ? endNextDate : CdJodaTimeUtil.max((LocalDateTime)this.end, (LocalDateTime)endNextDate);
            });
        }
        return true;
    }

    private LocalDateTime toNextDate(LocalDateTime date) {
        OlapLevelType levelType = ((IOlapBuilderHierarchyLevelDef)CdCollections.last(((OlapBuilderTimeWizardHierarchy)this.dimension.getDefaultHierarchy()).getLevels())).getLevelType();
        return levelType.toNextDate(date);
    }

    @Nullable
    private Locale getNullableLocale(OlapBuilderTimeWizardHierarchy hierarchy) {
        Locale hierLocal = hierarchy.getLocale();
        return hierLocal == null ? this.olapDimension.getLocale() : hierLocal;
    }

    @Nullable
    private void forEach(@Nullable Object javaNativeDataValue, Consumer<LocalDateTime> consumer) {
        if (javaNativeDataValue == null) {
            return;
        }
        if (javaNativeDataValue instanceof CdIComparableList) {
            CdIComparableList nativeDataValue = (CdIComparableList)javaNativeDataValue;
            for (int i = 0; i < nativeDataValue.size(); ++i) {
                this.forEach(nativeDataValue.get(i), consumer);
            }
            return;
        }
        if (javaNativeDataValue instanceof LocalDateTime) {
            LocalDateTime nativeDataValue = (LocalDateTime)javaNativeDataValue;
            consumer.accept(nativeDataValue);
            return;
        }
        if (javaNativeDataValue instanceof LocalDate) {
            LocalDate date = (LocalDate)javaNativeDataValue;
            consumer.accept(date.toLocalDateTime(LocalTime.MIDNIGHT));
            return;
        }
        throw new CdShouldNotBeHereProgrammingException("Wrong data type " + javaNativeDataValue.getClass().getName());
    }

    private class Builder {
        private TimeWizardTable table;
        private ArrayList<OlapBuilderMultiLevelHierarchy> mlHierarchies;
        private OlapBuilderMultiLevelHierarchy defaultHierarchy;
        final /* synthetic */ OlapBuilderTimeWizardDimensionBuilder this$0;

        private Builder(OlapBuilderTimeWizardDimensionBuilder olapBuilderTimeWizardDimensionBuilder) {
            OlapBuilderTimeWizardDimensionBuilder olapBuilderTimeWizardDimensionBuilder2 = olapBuilderTimeWizardDimensionBuilder;
            Objects.requireNonNull(olapBuilderTimeWizardDimensionBuilder2);
            this.this$0 = olapBuilderTimeWizardDimensionBuilder2;
        }

        public void init() {
            boolean optimizeHollow = true;
            OlapLevelType smallestLevelType = null;
            List hierarchies = this.this$0.dimension.getHierarchies();
            OlapBuilderTimeWizardHierarchy firstHierarchy = (OlapBuilderTimeWizardHierarchy)hierarchies.get(0);
            if (!hierarchies.isEmpty()) {
                optimizeHollow = this.checkBaseIsOptimizable(firstHierarchy);
            }
            for (Object hierarchy : hierarchies) {
                optimizeHollow &= !this.definesStartEndDate((OlapBuilderTimeWizardHierarchy)hierarchy);
                for (IOlapBuilderHierarchyLevelDef iOlapBuilderHierarchyLevelDef : ((OlapBuilderTimeWizardHierarchy)hierarchy).getLevels()) {
                    OlapLevelType levelType = iOlapBuilderHierarchyLevelDef.getLevelType();
                    smallestLevelType = smallestLevelType == null || levelType != null && smallestLevelType.ordinal() < levelType.ordinal() ? levelType : smallestLevelType;
                }
            }
            boolean hasTimeLevel = false;
            for (OlapBuilderTimeWizardHierarchy hierarchy : hierarchies) {
                for (OlapBuilderTimeWizardHierarchyLevel levelDef : hierarchy.getLevelDefinitions()) {
                    hasTimeLevel = hasTimeLevel || levelDef.getType() != null && levelDef.getType().hasTimeInformation();
                }
            }
            this.this$0.olapDimension.setKeyType(hasTimeLevel);
            ArrayList<TimeWizardColumn> columns = new ArrayList<TimeWizardColumn>();
            this.mlHierarchies = new ArrayList();
            for (OlapBuilderTimeWizardHierarchy olapBuilderTimeWizardHierarchy : hierarchies) {
                OlapBuilderMultiLevelHierarchy mlHierarchy = this.createHierarchyDef(olapBuilderTimeWizardHierarchy);
                OlapBuilderTimeWizardHierarchyLevel[] levelDefinitions = olapBuilderTimeWizardHierarchy.getLevelDefinitions();
                boolean hasAncestorRelativeKey = false;
                for (int i = 0; i < levelDefinitions.length; ++i) {
                    IOlapBuilderHierarchyLevelDef baseLevel;
                    OlapBuilderTimeWizardHierarchyLevel levelDef = levelDefinitions[i];
                    TimeWizardColumn keyColumn = null;
                    TimeWizardColumn nameColumn = null;
                    if (optimizeHollow && this.defaultHierarchy != null && this.this$0.getNullableLocale(firstHierarchy) == this.this$0.getNullableLocale(olapBuilderTimeWizardHierarchy) && (baseLevel = this.lookupSameLevelInBase(firstHierarchy, this.defaultHierarchy, levelDef)) != null) {
                        keyColumn = (TimeWizardColumn)baseLevel.getKeyColumns().get(0);
                        nameColumn = (TimeWizardColumn)baseLevel.getNameColumn();
                    }
                    if (nameColumn == null) {
                        keyColumn = new TimeWizardColumn(this.this$0, olapBuilderTimeWizardHierarchy, levelDef, ".key", levelDef.useRelativeKey() ? OlapBuilderInputType.SHORT : (hasTimeLevel ? OlapBuilderInputType.DATETIME : OlapBuilderInputType.DATE));
                        nameColumn = new TimeWizardColumn(this.this$0, olapBuilderTimeWizardHierarchy, levelDef, ".name", OlapBuilderInputType.STRING);
                    }
                    columns.add(keyColumn);
                    columns.add(nameColumn);
                    OlapBuilderHierarchyLevel level = new OlapBuilderHierarchyLevel(levelDef, keyColumn, nameColumn, levelDef.getOrderKind(), olapBuilderTimeWizardHierarchy.isFactIndexing(i), !hasAncestorRelativeKey && levelDef.getType().keyUniqueInLevel());
                    mlHierarchy.addLevel(level);
                    hasAncestorRelativeKey |= levelDef.useRelativeKey();
                }
                this.defaultHierarchy = mlHierarchy.isDefault() ? mlHierarchy : this.defaultHierarchy;
                this.mlHierarchies.add(mlHierarchy);
            }
            this.table = new TimeWizardTable(this.this$0, smallestLevelType, hasTimeLevel, this.this$0.start, this.this$0.end);
            this.table.resetColumns(columns);
        }

        protected boolean checkBaseIsOptimizable(OlapBuilderTimeWizardHierarchy firstHierarchy) {
            if (firstHierarchy.isDefault()) {
                for (IOlapBuilderHierarchyLevelDef levelDef : firstHierarchy.getLevels()) {
                    if (levelDef.getLevelType() != OlapLevelType.WEEK) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Nullable
        private IOlapBuilderHierarchyLevelDef lookupSameLevelInBase(OlapBuilderTimeWizardHierarchy defaultHierarchy, OlapBuilderMultiLevelHierarchy hierarchy, OlapBuilderTimeWizardHierarchyLevel levelDef) {
            for (int i = 0; i < defaultHierarchy.getLevelDefinitions().length; ++i) {
                OlapBuilderTimeWizardHierarchyLevel baseLevel = defaultHierarchy.getLevelDefinitions()[i];
                if (baseLevel.getType() != levelDef.getType() || baseLevel.useRelativeKey() != levelDef.useRelativeKey() || !baseLevel.getNameFormat().equals(levelDef.getNameFormat())) continue;
                return hierarchy.getLevels().get(i);
            }
            return null;
        }

        private boolean definesStartEndDate(OlapBuilderTimeWizardHierarchy defaultHierarchy) {
            for (OlapBuilderTimeWizardHierarchyLevel level : defaultHierarchy.getLevelDefinitions()) {
                if (level.getFrom() == null && level.getTo() == null) continue;
                return true;
            }
            return false;
        }

        private OlapBuilderMultiLevelHierarchy createHierarchyDef(OlapBuilderTimeWizardHierarchy hierarchy) {
            OlapBuilderAllLevelParsedDefinition allDef = hierarchy.hasAll() ? OlapBuilderAllLevelParsedDefinition.create(hierarchy.getAllLevelName(), hierarchy.getAllMemberName()) : OlapBuilderAllLevelParsedDefinition.UNDEFINED;
            OlapBuilderMultiLevelHierarchy newHierarchyDef = new OlapBuilderMultiLevelHierarchy(hierarchy.getName(), hierarchy.isDefault(), hierarchy.getExcelTimeLineSupport(), allDef, new IOlapBuilderHierarchyLevelDef[0]);
            newHierarchyDef.setTupleDimensionalityIndex(hierarchy.getTupleDimensionalityIndex());
            newHierarchyDef.setFolderName(hierarchy.getFolderName());
            newHierarchyDef.setLocale(hierarchy.getLocale());
            return newHierarchyDef;
        }
    }

    private class TimeWizardTable
    extends OlapBuilderBaseDataTable<OlapBuilderInMemoryConnection> {
        private final OlapLevelType smallestLevelType;
        private final boolean hasTimeLevel;
        private final LocalDateTime start;
        private final LocalDateTime end;

        public TimeWizardTable(OlapBuilderTimeWizardDimensionBuilder olapBuilderTimeWizardDimensionBuilder, OlapLevelType smallestLevelType, boolean hasTimeLevel, LocalDateTime start, LocalDateTime end) {
            Objects.requireNonNull(olapBuilderTimeWizardDimensionBuilder);
            this.smallestLevelType = smallestLevelType;
            this.hasTimeLevel = hasTimeLevel;
            this.start = start;
            this.end = end;
        }

        @Override
        public String getInternalFriendlyTypeName() {
            return "Time Wizard Table";
        }

        @Override
        protected IOlapBuilderTableRowReader<OlapBuilderInMemoryConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
            return new OlapBuilderAbstractTableRowReader<IOlapBuilderDataTableDef<OlapBuilderInMemoryConnection>, OlapBuilderInMemoryConnection>(this, context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)this, "TimeWizardTable-RowReader"){
                LocalDateTime currentDate;
                final /* synthetic */ TimeWizardTable this$1;
                {
                    TimeWizardTable timeWizardTable = this$1;
                    Objects.requireNonNull(timeWizardTable);
                    this.this$1 = timeWizardTable;
                    super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
                }

                @Override
                public void doInit() {
                    this.currentDate = null;
                }

                @Override
                public boolean isRowSafe() {
                    return false;
                }

                @Override
                @Nullable
                public IOlapBuilderTableRow doNextRow() {
                    if (this.this$1.end == null) {
                        return null;
                    }
                    LocalDateTime rowDate = this.currentDate == null ? (this.currentDate = this.this$1.start) : (this.currentDate = this.this$1.smallestLevelType.getNextDate(this.currentDate));
                    if (!rowDate.isBefore((ReadablePartial)this.this$1.end)) {
                        return null;
                    }
                    return columnDef -> ((TimeWizardColumn)columnDef).getValue(rowDate, this.this$1.hasTimeLevel);
                }
            };
        }

        @Override
        @Nullable
        protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
            return null;
        }

        @Override
        protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
            return reader;
        }
    }

    private class TimeWizardColumn
    extends OlapBuilderDataColumn {
        private final OlapBuilderTimeWizardHierarchy hierarchy;
        private final OlapBuilderTimeWizardHierarchyLevel level;
        final /* synthetic */ OlapBuilderTimeWizardDimensionBuilder this$0;

        public TimeWizardColumn(OlapBuilderTimeWizardDimensionBuilder olapBuilderTimeWizardDimensionBuilder, OlapBuilderTimeWizardHierarchy hierarchy, OlapBuilderTimeWizardHierarchyLevel level, String name, OlapBuilderInputType type) {
            OlapBuilderTimeWizardDimensionBuilder olapBuilderTimeWizardDimensionBuilder2 = olapBuilderTimeWizardDimensionBuilder;
            Objects.requireNonNull(olapBuilderTimeWizardDimensionBuilder2);
            this.this$0 = olapBuilderTimeWizardDimensionBuilder2;
            super(type, type.toString(), hierarchy.getName() + "." + level.getName() + name);
            this.hierarchy = hierarchy;
            this.level = level;
        }

        @Override
        public IOlapBuilderDataColumnDef duplicateForView(String newName) {
            throw new RuntimeException("internal error: inconsistent time-wizard column usage");
        }

        @Nullable
        Comparable getValue(LocalDateTime date, boolean keyWithTimeInfo) {
            if (this.level.getFrom() != null && date.isBefore((ReadablePartial)this.level.getFrom())) {
                return null;
            }
            if (this.level.getTo() != null && date.isAfter((ReadablePartial)this.level.getTo())) {
                return null;
            }
            OlapLevelType levelType = this.level.getType();
            LocalDateTime dateTime = levelType.transformToValidDate(date, this.this$0.getNullableLocale(this.hierarchy));
            if (this.getType() == OlapBuilderInputType.STRING) {
                return levelType.getMemberNameFor(this.level.getNameFormat(), this.this$0.getNullableLocale(this.hierarchy), dateTime);
            }
            if (this.level.useRelativeKey()) {
                return Short.valueOf((short)levelType.getRelativeId(dateTime, this.this$0.getNullableLocale(this.hierarchy)));
            }
            return keyWithTimeInfo ? dateTime : dateTime.toLocalDate();
        }
    }
}

