/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.dimension;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class OlapBuilderDimensionBuilderExperimental<T extends IOlapBuilderHierarchyDef> {
    private static final int BATCH_SIZE = 10000;
    private final ExecutorService executors = Executors.newFixedThreadPool(6);
    private final int defaultHierarchyBuilderIndex;
    private final List<IOlapBuilderDimensionListener> hierarchyBuilders;
    private List<IOlapBuilderTableRow> dataBatch;
    private int rowNB = 0;

    public OlapBuilderDimensionBuilderExperimental(int defaultHierarchyBuilderIndex, List<IOlapBuilderDimensionListener> hierarchyBuilders) {
        this.defaultHierarchyBuilderIndex = defaultHierarchyBuilderIndex;
        this.hierarchyBuilders = hierarchyBuilders;
    }

    void onTableCompleted(OlapBuilderContext context) {
        this.processBatch(context);
    }

    void onNewRow(OlapBuilderContext context, IOlapBuilderTableRow row) {
        ++this.rowNB;
        if (this.dataBatch == null) {
            this.dataBatch = new ArrayList<IOlapBuilderTableRow>(10000);
        }
        if (this.dataBatch.size() < 10000) {
            this.dataBatch.add(row);
            return;
        }
        this.processBatch(context);
    }

    private void processBatch(OlapBuilderContext context) {
        OlapLoggers.GENERAL.error((Object)("executing - base member - batch from row: " + this.rowNB));
        IOlapBuilderDimensionListener baseHierarchyBuilder = this.hierarchyBuilders.get(this.defaultHierarchyBuilderIndex);
        int count = this.dataBatch.size();
        long startMS = System.currentTimeMillis();
        for (int dd = 0; dd < count; ++dd) {
            IOlapBuilderTableRow data = this.dataBatch.get(dd);
            baseHierarchyBuilder.addToHierarchy(data);
        }
        OlapLoggers.GENERAL.error((Object)("executing - base member - : " + CdTimeUtils.formatMillis((long)(System.currentTimeMillis() - startMS))));
        OlapLoggers.GENERAL.error((Object)("executing batch from row: " + this.rowNB));
        int size = this.hierarchyBuilders.size();
        CountDownLatch sync = new CountDownLatch(size - 1);
        for (int hh = 0; hh < size; ++hh) {
            if (hh == this.defaultHierarchyBuilderIndex) continue;
            IOlapBuilderDimensionListener hierarchyBuilder = this.hierarchyBuilders.get(hh);
            Task task = new Task(context, sync, hierarchyBuilder, this.dataBatch);
        }
        OlapLoggers.GENERAL.error((Object)"executing batch: done");
        this.dataBatch = new ArrayList<IOlapBuilderTableRow>(10000);
    }

    static class Task
    implements Runnable {
        private final OlapBuilderContext context;
        private final CountDownLatch sync;
        private final IOlapBuilderDimensionListener hierarchyBuilder;
        private final List<IOlapBuilderTableRow> dataBatch;

        public Task(OlapBuilderContext context, CountDownLatch sync, IOlapBuilderDimensionListener hierarchyBuilder, List<IOlapBuilderTableRow> dataBatch) {
            this.context = context;
            this.sync = sync;
            this.hierarchyBuilder = hierarchyBuilder;
            this.dataBatch = dataBatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startMS = System.currentTimeMillis();
            try {
                this.context.assertNotCancelling("add-member");
                int count = this.dataBatch.size();
                for (int dd = 0; dd < count; ++dd) {
                    IOlapBuilderTableRow data = this.dataBatch.get(dd);
                    this.hierarchyBuilder.addToHierarchy(data);
                }
            }
            finally {
                this.sync.countDown();
            }
            OlapLoggers.GENERAL.error((Object)("executing batch: hierarchy done: " + this.hierarchyBuilder.getHierarchyName() + "  " + CdTimeUtils.formatMillis((long)(System.currentTimeMillis() - startMS))));
        }
    }
}

