/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.bridge;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdComparableList;
import crazydev.common.collection.CdIComparableList;
import crazydev.common.collection.CdMultiColumnValue;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.system.CdVirtualMachine;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.bridge.IOlapBridgeResolver;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeDef;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeMultipleKeyMap;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeSingleKeyMap;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactSolveRowError;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSingleBridgeBaseMap<T>
implements IOlapBridgeResolver {
    private static long SHALLOW_SIZE_OF = -1L;
    protected final Map<T, CdComparableList> map;
    private final OlapSingleBridgeDef definition;

    public OlapSingleBridgeBaseMap(OlapSingleBridgeDef definition) {
        this.definition = definition;
        this.map = new HashMap<T, CdComparableList>();
    }

    protected OlapSingleBridgeBaseMap(OlapSingleBridgeDef definition, Map<T, CdComparableList> map) {
        this.definition = definition;
        this.map = map;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        Optional any = this.map.entrySet().stream().findAny();
        if (any.isPresent()) {
            long keySize = CdRamUsageEstimator.shallowSizeOf(((Map.Entry)any.get()).getKey()) * (long)this.map.size();
            long countTotalListSize = this.map.values().stream().mapToLong(ArrayList::size).sum();
            long valueSize = countTotalListSize * (CdRamUsageEstimator.shallowSizeOf((Object)((CdComparableList)((Map.Entry)any.get()).getValue()).get(0)) + (long)CdVirtualMachine.NUM_BYTES_OBJECT_REF) + (long)this.map.size() * CdRamUsageEstimator.shallowSizeOf(((Map.Entry)any.get()).getValue());
            size += keySize + valueSize;
        }
        return size;
    }

    public OlapSingleBridgeDef getDefinition() {
        return this.definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(IOlapBuilderTableRow row, List<IOlapBuilderDataColumnDef> keyCols, List<IOlapBuilderDataColumnDef> valCols) {
        Map<T, CdComparableList> map = this.map;
        synchronized (map) {
            this.doAddRow(row, keyCols, valCols);
        }
    }

    protected abstract void doAddRow(IOlapBuilderTableRow var1, List<IOlapBuilderDataColumnDef> var2, List<IOlapBuilderDataColumnDef> var3);

    @Override
    public abstract Comparable getValues(OlapDimension var1, Comparable var2, boolean var3) throws OlapBuilderFactSolveRowError;

    public Map<T, CdComparableList> _map4Test() {
        return this.map;
    }

    void addKeyVal(T key, Comparable value) {
        CdComparableList list = this.map.computeIfAbsent(key, k -> new CdComparableList(1));
        if (value instanceof CdIComparableList) {
            CdIComparableList compList = (CdIComparableList)value;
            for (int i = 0; i < compList.size(); ++i) {
                list.addIfNotPresent(compList.get(i));
            }
        } else {
            list.addIfNotPresent(value);
        }
    }

    @Nullable
    Comparable logErrorOnMissingKey(OlapDimension dimension, Object key, boolean useUnknownMembers) throws OlapBuilderFactSolveRowError {
        if (useUnknownMembers) {
            return null;
        }
        OlapBuilderErrorException userError = new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_MEMBER_KEY_BRIDGE_KEY_NOT_FOUND, new Serializable[]{dimension.getName(OlapNameContext.DEFAULT_VALUES), key == null ? "NULL" : key.toString()});
        throw new OlapBuilderFactSolveRowError(userError, dimension);
    }

    abstract void commitDiff(OlapSingleBridgeBaseMap<T> var1);

    void save(M_BackupContext context, S_BackupOutputStream out) throws IOException {
        OlapLoggers.BACKUP.info((Object)("[backup] saving bridge for schema [" + context.getSchemaName() + "] [" + this.definition.getTableId() + "]"));
        this.definition.save(out);
        if (this instanceof OlapSingleBridgeSingleKeyMap) {
            out.writeInt(1);
        } else if (this instanceof OlapSingleBridgeMultipleKeyMap) {
            out.writeInt(2);
        } else {
            throw new RuntimeException("internal error: unexpected bridge type [" + this.getClass().getSimpleName() + "]");
        }
        out.writeInt(this.map.size());
        for (Map.Entry<T, CdComparableList> entry : this.map.entrySet()) {
            T key = entry.getKey();
            this.save(out, key);
            CdComparableList value = entry.getValue();
            out.writeInt(value.size());
            for (int ii = 0; ii < value.size(); ++ii) {
                Object value_ = value.get(ii);
                this.save(out, value_);
            }
        }
    }

    private void save(S_BackupOutputStream out, @Nullable Object value) throws IOException {
        DataOutputStream dOut = new DataOutputStream(out);
        if (value instanceof Comparable[]) {
            dOut.writeByte(-1);
            Comparable[] value_ = (Comparable[])value;
            dOut.writeInt(value_.length);
            for (Comparable comparable : value_) {
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(comparable);
                serializer.write(dOut, comparable);
            }
        } else if (value instanceof Comparable) {
            Comparable value_ = (Comparable)value;
            OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(value_);
            serializer.write(dOut, value_);
        } else if (value == null) {
            OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(null);
            serializer.write(dOut, null);
        } else {
            throw new RuntimeException("internal error: unsupported type [" + value.getClass().getName() + "]");
        }
        dOut.flush();
    }

    public static OlapSingleBridgeBaseMap restore(M_RestoreContext context, S_BackupInputStream in) throws IOException {
        OlapSingleBridgeDef definition = OlapSingleBridgeDef.restore(context, in);
        DataInputStream dIn = new DataInputStream(in);
        int type = dIn.readInt();
        if (type == 1) {
            OlapSingleBridgeBaseMap bridge = OlapSingleBridgeSingleKeyMap.restore(context, dIn, definition);
            return bridge;
        }
        if (type == 2) {
            OlapSingleBridgeBaseMap bridge = OlapSingleBridgeMultipleKeyMap.restore(context, dIn, definition);
            return bridge;
        }
        throw new RuntimeException("internal error: unexpected bridge type [" + type + "]");
    }

    protected static <T> Map<T, CdComparableList> restoreMap(M_RestoreContext context, DataInputStream in) throws IOException {
        HashMap<T, CdComparableList> map = new HashMap<T, CdComparableList>();
        int size = in.readInt();
        for (int ii = 0; ii < size; ++ii) {
            Object key = OlapSingleBridgeBaseMap.restoreMapValue(in);
            if (key instanceof CdComparableArray) {
                CdComparableArray array = (CdComparableArray)key;
                key = new CdMultiColumnValue(array.getArray());
            }
            int valueSize = in.readInt();
            CdComparableList value = new CdComparableList(valueSize);
            for (int vv = 0; vv < valueSize; ++vv) {
                T item = OlapSingleBridgeBaseMap.restoreMapValue(in);
                value.add(item);
            }
            map.put(key, value);
        }
        return map;
    }

    private static <T> T restoreMapValue(DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == -1) {
            Comparable[] value = new Comparable[in.readInt()];
            for (int ii = 0; ii < value.length; ++ii) {
                byte itemType = in.readByte();
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(itemType);
                Object itemValue = serializer.read(in);
                value[ii] = itemValue;
            }
            return (T)value;
        }
        OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(type);
        Object value = serializer.read(in);
        return value;
    }

    int getKeySize() {
        return this.map.size();
    }
}

