/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.bridge;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeBaseMap;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapBridgeMapContainer {
    private static long SHALLOW_SIZE_OF = -1L;
    private final Map<OlapSingleBridgeDef, OlapSingleBridgeBaseMap> singleBridgeCache = new ConcurrentHashMap<OlapSingleBridgeDef, OlapSingleBridgeBaseMap>();
    private final Map<OlapSingleBridgeDef, OlapSingleBridgeBaseMap> singleBridgeCacheDiff = new ConcurrentHashMap<OlapSingleBridgeDef, OlapSingleBridgeBaseMap>();

    public long sizeOf() {
        if (this.singleBridgeCache.isEmpty() && this.singleBridgeCacheDiff.isEmpty()) {
            return 0L;
        }
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        for (OlapSingleBridgeBaseMap bridge : this.singleBridgeCache.values()) {
            size += bridge.sizeOf();
        }
        for (OlapSingleBridgeBaseMap bridge : this.singleBridgeCacheDiff.values()) {
            size += bridge.sizeOf();
        }
        return size;
    }

    public Collection<OlapSingleBridgeDef> getDefinitions() {
        return this.singleBridgeCache.keySet();
    }

    @Nullable
    public OlapSingleBridgeDef lookupDefinition(String tableId, List<String> keyColNames, List<String> valColNames) {
        BridgeDefKey lookupKey = new BridgeDefKey(tableId, keyColNames, valColNames);
        for (OlapSingleBridgeDef bridgeDef : this.singleBridgeCache.keySet()) {
            BridgeDefKey key = new BridgeDefKey(bridgeDef);
            if (!lookupKey.equals(key)) continue;
            return bridgeDef;
        }
        return null;
    }

    public void clear() {
        this.singleBridgeCache.clear();
        this.singleBridgeCacheDiff.clear();
    }

    public OlapSingleBridgeBaseMap getOrCreateForSetup(@Nullable OlapSingleBridgeDef definition) {
        if (definition == null) {
            return null;
        }
        if (this.singleBridgeCacheDiff.get(definition) != null) {
            throw new RuntimeException("internal error: incr. load not committed for bridges : " + String.valueOf(definition));
        }
        OlapSingleBridgeBaseMap bridge = this.singleBridgeCache.computeIfAbsent(definition, OlapSingleBridgeDef::createMap);
        return bridge;
    }

    public OlapSingleBridgeBaseMap getForBuilding(@Nullable OlapSingleBridgeDef definition, boolean useIncrMap) {
        OlapSingleBridgeBaseMap bridge;
        if (definition == null) {
            return null;
        }
        if (useIncrMap) {
            bridge = this.singleBridgeCacheDiff.computeIfAbsent(definition, OlapSingleBridgeDef::createMap);
        } else {
            bridge = this.singleBridgeCache.get(definition);
            if (bridge == null) {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }
        return bridge;
    }

    public void commitDiff() {
        for (OlapSingleBridgeBaseMap diff : this.singleBridgeCacheDiff.values()) {
            OlapSingleBridgeDef def = diff.getDefinition();
            OlapSingleBridgeBaseMap bridge = this.singleBridgeCache.get(def);
            if (bridge != null) {
                bridge.commitDiff(diff);
                continue;
            }
            this.singleBridgeCache.put(def, diff);
        }
        this.singleBridgeCacheDiff.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(M_BackupContext context) throws IOException {
        Map<OlapSingleBridgeDef, OlapSingleBridgeBaseMap> cache;
        S_BackupMode mode = context.getMode();
        if (mode == S_BackupMode.FULL_LOAD) {
            cache = this.singleBridgeCache;
        } else if (mode == S_BackupMode.INCR_LOAD) {
            cache = this.singleBridgeCacheDiff;
        } else {
            return;
        }
        if (context.isCancelling()) {
            return;
        }
        long startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP.info((Object)("[backup] saving bridges for schema [" + context.getSchemaName() + "] [" + cache.size() + "]"));
        if (!cache.isEmpty()) {
            OlapEngineBackupConfiguration configuration = context.getConfiguration();
            File dir = context.getBridgesDir();
            File file = new File(dir, "bridge.icc-data");
            try (S_BackupOutputStream out = new S_BackupOutputStream(configuration, file);){
                out.writeInt(cache.size());
                for (OlapSingleBridgeBaseMap bridge : cache.values()) {
                    if (context.isCancelling()) break;
                    bridge.save(context, out);
                }
                if (!context.isCancelling()) {
                    out.sync();
                }
            }
        }
        OlapLoggers.BACKUP.info((Object)("[backup] saved bridges for schema [" + context.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS) + " ]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(M_RestoreContext context) throws IOException {
        S_BackupMode mode = context.getMode();
        if (mode != S_BackupMode.FULL_LOAD && mode != S_BackupMode.INCR_LOAD) {
            return;
        }
        if (context.isCancelling()) {
            return;
        }
        long startMS = System.currentTimeMillis();
        OlapLoggers.BACKUP.info((Object)("[backup] restoring bridges for schema [" + context.getSchemaName() + "]"));
        OlapEngineBackupConfiguration configuration = context.getConfiguration();
        File dir = context.getBridgesDir();
        File file = new File(dir, "bridge.icc-data");
        if (file.exists()) {
            S_BackupInputStream in = new S_BackupInputStream(configuration, file);
            try {
                Map<OlapSingleBridgeDef, OlapSingleBridgeBaseMap> cache = mode == S_BackupMode.FULL_LOAD ? this.singleBridgeCache : this.singleBridgeCacheDiff;
                int count = in.readInt();
                for (int ii = 0; ii < count && !context.isCancelling(); ++ii) {
                    OlapSingleBridgeBaseMap bridge = OlapSingleBridgeBaseMap.restore(context, in);
                    cache.put(bridge.getDefinition(), bridge);
                }
                if (cache == this.singleBridgeCacheDiff) {
                    this.commitDiff();
                }
                in.sync();
            }
            finally {
                in.closeQuietly();
            }
        }
        OlapLoggers.BACKUP.info((Object)("[backup] restored bridges for schema [" + context.getSchemaName() + "] [ " + CdTimeUtils.formatMillisEx((long)startMS) + " ]"));
    }

    static class BridgeDefKey {
        final String tableId;
        final List<String> keyColNames;
        final List<String> valColNames;

        BridgeDefKey(String tableId, List<String> keyColNames, List<String> valColNames) {
            this.tableId = tableId;
            this.keyColNames = keyColNames;
            this.valColNames = valColNames;
        }

        BridgeDefKey(OlapSingleBridgeDef definition) {
            this.tableId = definition.getTableId();
            this.keyColNames = BridgeDefKey.colNames(definition.getKeyCols());
            this.valColNames = BridgeDefKey.colNames(definition.getValCols());
        }

        static List<String> colNames(List<IOlapBuilderDataColumnDef> cols) {
            ArrayList<String> names = new ArrayList<String>();
            for (IOlapBuilderDataColumnDef col : cols) {
                names.add(col.getName());
            }
            return names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BridgeDefKey that = (BridgeDefKey)o;
            if (!this.tableId.equals(that.tableId)) {
                return false;
            }
            if (!this.keyColNames.equals(that.keyColNames)) {
                return false;
            }
            return this.valColNames.equals(that.valColNames);
        }

        public int hashCode() {
            int result = this.tableId.hashCode();
            result = 31 * result + this.keyColNames.hashCode();
            result = 31 * result + this.valColNames.hashCode();
            return result;
        }
    }
}

