/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.parser;

import crazydev.common.collection.CdCollections;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.goodies.headerdef.annotation.IOlapBuilderHeaderAnnotationDefinition;
import crazydev.iccube.builder.goodies.headerdef.dimension.annotation.OlapBuilderDefaultTimeDimensionAnnotation;
import crazydev.iccube.builder.goodies.headerdef.dimension.annotation.OlapBuilderStatisticalDimensionAnnotation;
import crazydev.iccube.builder.goodies.headerdef.dimension.annotation.OlapBuilderTimeDimensionAnnotation;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.annotation.OlapBuilderAllLevelAnnotation;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.annotation.OlapBuilderAllMemberAnnotation;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.annotation.OlapBuilderDefaultHierarchyAnnotation;
import crazydev.iccube.builder.goodies.headerdef.level.annotation.OlapBuilderLevelTypeAnnotation;
import crazydev.iccube.builder.goodies.headerdef.level.annotation.OlapBuilderLevelUniqueAnnotation;
import crazydev.iccube.builder.goodies.headerdef.measure.annotation.OlapBuilderAggregationTypeAnnotation;
import crazydev.iccube.builder.goodies.headerdef.measure.annotation.OlapBuilderFormatAnnotation;
import crazydev.iccube.builder.goodies.headerdef.parser.IOlapBuilderDefinitionParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderColumnDefInfoParser<DEFINITION>
implements IOlapBuilderDefinitionParser<IOlapBuilderDataColumnDef, DEFINITION> {
    private static final List<IOlapBuilderHeaderAnnotationDefinition> ANNOTATIONS = new ArrayList<IOlapBuilderHeaderAnnotationDefinition>();

    @Override
    public final DEFINITION parse(IOlapBuilderDataColumnDef columnDef) {
        String stringDefinition = columnDef.getName();
        try {
            MdxIdentifierExpression identifierExpression;
            List<CdMdxIdentifierToken> tokens;
            MdxExpression mdxExpression = OlapBuilderColumnDefInfoParser.parseMdxExpression(stringDefinition);
            if (mdxExpression instanceof MdxIdentifierExpression && CdCollections.isNotEmpty(tokens = (identifierExpression = (MdxIdentifierExpression)mdxExpression).getParts())) {
                return this.parseDefinition(tokens, columnDef, identifierExpression);
            }
        }
        catch (CdMdxScannerException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN_WITH_ERROR, new Serializable[]{stringDefinition, ex.getMessage()});
        }
        catch (MdxParserException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN_WITH_ERROR, new Serializable[]{stringDefinition, ex.getMessage()});
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN, new Serializable[]{stringDefinition});
    }

    protected abstract DEFINITION parseDefinition(List<CdMdxIdentifierToken> var1, IOlapBuilderDataColumnDef var2, MdxIdentifierExpression var3);

    public static MdxExpression parseMdxExpression(String mdx) throws MdxParserException, CdMdxScannerException {
        OlapProperties properties = new OlapProperties(Arrays.asList(OlapPropertyDescriptions.excelFixDotMembers.asProperty(true)));
        OlapFunctionRepository functionRepository = new OlapFunctionRepository(true);
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager(true);
        MdxParsingContext context = new MdxParsingContext(properties, functionRepository, schemaFunctionRepository.createSnapshot(), memberPropertyManager, false);
        String mdxHash = UUID.randomUUID().toString();
        MdxExpression mdxExpression = MdxParser.parseValueExpression(context, mdx, mdxHash);
        return mdxExpression;
    }

    @Nullable
    protected String findTokenValue(List<CdMdxIdentifierToken> tokens, int position) {
        if (tokens.size() > position) {
            CdMdxIdentifierToken token = tokens.get(position);
            if (token.isKey()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_UNSUPPORTED_SYNTAX_FOR_KEY_COLUMN, new Serializable[]{token.getMdx()});
            }
            return token.getIdentifier();
        }
        return null;
    }

    protected List<String> parseAnnotations(MdxIdentifierExpression identifierExpression, String stringDefinition) {
        int pos = identifierExpression.getLastToken().getEndOffset();
        if (pos == stringDefinition.length()) {
            return Collections.emptyList();
        }
        if (pos < stringDefinition.length()) {
            ArrayList<String> allAnnotations = new ArrayList<String>();
            String annotationString = StringUtils.substring((String)stringDefinition, (int)pos);
            String[] annotations = annotationString.split("@");
            for (int idx = 0; idx < annotations.length; ++idx) {
                String annotation = annotations[idx];
                if (idx == 0) {
                    if (annotation.trim().isEmpty()) continue;
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN, new Serializable[]{stringDefinition});
                }
                allAnnotations.add(this.parseAnnotation(annotation, stringDefinition));
            }
            return allAnnotations;
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN, new Serializable[]{stringDefinition});
    }

    private String parseAnnotation(String annotation, String stringDefinition) {
        for (IOlapBuilderHeaderAnnotationDefinition ann : ANNOTATIONS) {
            if (!ann.isAnnotation(annotation)) continue;
            return annotation;
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_UNKNOWN_ANNOTATION, new Serializable[]{annotation, stringDefinition});
    }

    static {
        ANNOTATIONS.add(OlapBuilderDefaultHierarchyAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderAllLevelAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderAllMemberAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderLevelTypeAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderLevelUniqueAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderTimeDimensionAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderDefaultTimeDimensionAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderStatisticalDimensionAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderAggregationTypeAnnotation.INSTANCE);
        ANNOTATIONS.add(OlapBuilderFormatAnnotation.INSTANCE);
    }
}

