/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.factory;

import crazydev.common.collection.CdCollections;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineDataTable;
import crazydev.iccube.builder.goodies.headerdef.parser.OlapBuilderColumnDefInfoParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.view.columnfilter.OlapBuilderColumnFilterDataView;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OlapBuilderOneTable2Multiple<T extends OlapBuilderAbstractConnection> {
    private final OlapBuilderLineDataTable<T> original;
    private final OlapBuilderColumnFilterDataView facts;
    private final List<IOlapBuilderTabularDataDef> dimensions = new ArrayList<IOlapBuilderTabularDataDef>();

    public OlapBuilderOneTable2Multiple(OlapBuilderLineDataTable<T> origTable) throws CdMdxScannerException, MdxParserException {
        this.original = origTable;
        ArrayList<String> dimensionNames = new ArrayList<String>();
        HashMap mapExpr = new HashMap();
        HashMap mapOrigCols = new HashMap();
        List<IOlapBuilderDataColumnDef> columns = origTable.getSelectedColumns();
        for (IOlapBuilderDataColumnDef columnDef : columns) {
            MdxExpression expr = OlapBuilderColumnDefInfoParser.parseMdxExpression(columnDef.getName());
            if (!(expr instanceof MdxIdentifierExpression)) continue;
            MdxIdentifierExpression idenExpr = (MdxIdentifierExpression)expr;
            String identifier = idenExpr.getFirstToken().getIdentifier();
            CdCollections.add(mapExpr, (Object)identifier, (Object)idenExpr);
            CdCollections.add(mapOrigCols, (Object)identifier, (Object)columnDef);
            if (dimensionNames.contains(identifier)) continue;
            dimensionNames.add(identifier);
        }
        OlapBuilderColumnFilterDataView facts = null;
        for (String dimensionName : dimensionNames) {
            ArrayList<IOlapBuilderDataColumnDef> tableCols = new ArrayList<IOlapBuilderDataColumnDef>();
            List originalCols = (List)mapOrigCols.get(dimensionName);
            List exprs = (List)mapExpr.get(dimensionName);
            boolean isDimension = dimensionName.equalsIgnoreCase("measures");
            HashMap<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> map = new HashMap<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>();
            for (int i = 0; i < exprs.size(); ++i) {
                MdxIdentifierExpression exp = (MdxIdentifierExpression)exprs.get(i);
                IOlapBuilderDataColumnDef col = (IOlapBuilderDataColumnDef)originalCols.get(i);
                String strippedName = isDimension && exp.getFirstToken().getIdentifier().equalsIgnoreCase("measures") ? exp.asMdx() : this.stripFirstToken(exp);
                String annotations = this.getAnnotation(col.getName(), exp);
                OlapBuilderDataColumn tableCol = new OlapBuilderDataColumn(col.getType(), col.getTableType(), strippedName + annotations);
                tableCols.add(tableCol);
                map.put(tableCol, col);
            }
            OlapBuilderColumnFilterDataView view = new OlapBuilderColumnFilterDataView(dimensionName, tableCols, origTable, map);
            if (isDimension) {
                facts = view;
                continue;
            }
            this.dimensions.add(view);
        }
        if (facts != null) {
            for (IOlapBuilderTabularDataDef dimension : this.dimensions) {
                OlapBuilderColumnFilterDataView dim = (OlapBuilderColumnFilterDataView)dimension;
                IOlapBuilderDataColumnDef dimCol = dimension.getSelectedColumns().get(dimension.getSelectedColumns().size() - 1);
                IOlapBuilderDataColumnDef ordimCol = dim.getOriginalColumn(dimCol);
                facts.addColumn(dimCol, ordimCol);
            }
        }
        this.facts = facts;
    }

    private String getAnnotation(String name, MdxIdentifierExpression exp) {
        int pos = exp.getLastToken().getEndOffset();
        if (name.length() == pos) {
            return "";
        }
        return name.substring(pos, name.length());
    }

    private String stripFirstToken(MdxIdentifierExpression exp) {
        String stripped = exp.subIdentifier(1, exp.getPartCount()).asMdx();
        return stripped;
    }

    public OlapBuilderColumnFilterDataView getFacts() {
        return this.facts;
    }

    public List<IOlapBuilderTabularDataDef> getDimensions() {
        return this.dimensions;
    }
}

