/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.factory;

import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.cube.OlapBuilderBaseCubeDefFactory;
import crazydev.iccube.builder.goodies.headerdef.OlapBuilderXmlDefinitionDimensionInfo;
import crazydev.iccube.builder.goodies.headerdef.dimension.OlapBuilderHeaderDefinitionDimensionFactory;
import crazydev.iccube.builder.goodies.headerdef.measure.OlapBuilderMeasuresDefParser;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHeaderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderHeaderCube;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.List;

public abstract class OlapBuilderDataSourceCubeDefFactory<CONNECTION extends IOlapBuilderConnection, DATASOURCE extends OlapBuilderBaseDataSource<CONNECTION>>
extends OlapBuilderBaseCubeDefFactory {
    protected OlapBuilderDataSourceCubeDefFactory() {
        this(null, null, false);
    }

    public OlapBuilderDataSourceCubeDefFactory(String cubeName, String cubeDescription, boolean aggregateDataSourceFacts) {
        super(cubeName, cubeDescription, aggregateDataSourceFacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOlapBuilderHeaderCubeDef createCubeDefinition(OlapBuilderConnectionPool connectionPool, OlapBuilderErrorManager errorManager) {
        this.validate(errorManager);
        DATASOURCE datasource = this.createDataSource();
        Object connection = connectionPool.getOrCreateOpenedConnection((OlapRuntimeContext)null, datasource);
        try {
            this.onCreateCubeDefinitionBegin(errorManager, connection, datasource);
            IOlapBuilderTabularDataDef factDataTable = this.getFactDataTable(connection, errorManager);
            ((OlapBuilderBaseDataSource)datasource).link(factDataTable);
            List<IOlapBuilderMeasureDef> measureDefinitions = OlapBuilderMeasuresDefParser.INSTANCE.parse(factDataTable.getSelectedColumns());
            OlapBuilderFacts<IOlapBuilderTabularDataDef> facts = new OlapBuilderFacts<IOlapBuilderTabularDataDef>("default", factDataTable, measureDefinitions, this.isAggregateDataSourceFacts());
            ArrayList<IOlapBuilderDimensionDef> dimensions = new ArrayList<IOlapBuilderDimensionDef>();
            for (CdPair<IOlapBuilderTabularDataDef, OlapBuilderXmlDefinitionDimensionInfo> cont : this.getDimensionTables(connection, errorManager)) {
                ((OlapBuilderBaseDataSource)datasource).link((IOlapBuilderTabularDataDef)cont.fst);
                IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> dimDef = OlapBuilderHeaderDefinitionDimensionFactory.create((IOlapBuilderTabularDataDef)cont.fst, (OlapBuilderXmlDefinitionDimensionInfo)cont.snd, this.getCubeName());
                dimensions.add(dimDef);
            }
            OlapBuilderHeaderCube cube = OlapBuilderHeaderCube.createCubeAndLinks(this.getCubeName(), this.getCubeDescription(), facts, dimensions);
            cube.addDimensions(dimensions);
            cube.addDataSource((IOlapBuilderDataSource)datasource);
            OlapBuilderHeaderCube olapBuilderHeaderCube = cube;
            return olapBuilderHeaderCube;
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }

    protected abstract DATASOURCE createDataSource();

    protected void onCreateCubeDefinitionBegin(OlapBuilderErrorManager errorManager, CONNECTION connection, DATASOURCE dataSource) {
    }

    protected abstract List<CdPair<IOlapBuilderTabularDataDef, OlapBuilderXmlDefinitionDimensionInfo>> getDimensionTables(CONNECTION var1, OlapBuilderErrorManager var2);

    protected abstract IOlapBuilderTabularDataDef getFactDataTable(CONNECTION var1, OlapBuilderErrorManager var2);

    protected abstract void validate(OlapBuilderErrorManager var1);

    public static class DimensionDefinition {
        @XmlElement(name="dimensionInfo", required=true)
        private OlapBuilderXmlDefinitionDimensionInfo dimensionInfo;

        public DimensionDefinition() {
        }

        public DimensionDefinition(OlapBuilderXmlDefinitionDimensionInfo dimensionInfo) {
            this.dimensionInfo = dimensionInfo;
        }

        public OlapBuilderXmlDefinitionDimensionInfo getDimensionInfo() {
            return this.dimensionInfo;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class FactsDefinition {
        @XmlElement(name="fileName", required=true)
        private String fileName;

        public FactsDefinition() {
        }

        public FactsDefinition(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }
}

