/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.column;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.goodies.headerdef.column.OlapBuilderColumnDefinitionParser;
import crazydev.iccube.builder.goodies.headerdef.parser.IOlapBuilderDefinitionParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.List;

public abstract class OlapBuilderColumnsDefinitionParser
implements IOlapBuilderDefinitionParser<String, List<IOlapBuilderDataColumnDef>> {
    public static List<IOlapBuilderDataColumnDef> parse(String[] columns, boolean addRowNumColumn) {
        return OlapBuilderColumnsDefinitionParser.parse(columns, addRowNumColumn, false, false, false);
    }

    public static List<IOlapBuilderDataColumnDef> parse(String[] columns, boolean addRowNumColumn, boolean addFileName, boolean removeQuotes, boolean partitionColumn) {
        ArrayList<IOlapBuilderDataColumnDef> columnDefinitions = new ArrayList<IOlapBuilderDataColumnDef>();
        if (addRowNumColumn) {
            columnDefinitions.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "rownum", "ic3-RowNum"));
        }
        if (addFileName) {
            columnDefinitions.add(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "string", "ic3-FileName"));
        }
        if (partitionColumn) {
            columnDefinitions.add(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "string", "ic3-Partition"));
        }
        for (String column : columns) {
            String colName = removeQuotes ? CdStringUtils.removeQuotes((String)column) : column;
            IOlapBuilderDataColumnDef columnDefinition = !colName.contains(">") ? OlapBuilderDataColumn.createStringColumn(colName.trim()) : OlapBuilderColumnDefinitionParser.getInstance().parse(colName);
            columnDefinitions.add(columnDefinition);
        }
        return columnDefinitions;
    }
}

