/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.factory.schema;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdFilter;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.cube.IOlapBuilderCubeDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderBaseSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderCubeDefFactories;
import crazydev.iccube.builder.model.def.IOlapBuilderCalcMemberDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHeaderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.OlapBuilderStoragePolicy;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyUniqueNameStyle;
import crazydev.iccube.builder.type.BackupType;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.MemberPropertyConsistencyCheckType;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.builder.type.NonEmptyCachePersistency;
import crazydev.iccube.builder.type.NonEmptyCachePolicy;
import crazydev.iccube.builder.type.NonEmptyCacheType;
import crazydev.iccube.builder.type.SchemaGarbageCollectorType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="cubeBasedSchemaFactory")
public class OlapBuilderCubeBasedSchemaDefFactory
extends OlapBuilderBaseSchemaDefFactory {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "schemaName");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "schemaDescription");
    public static final CdProperty GROUP = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "schemaGroup");
    public static final CdProperty LOAD_ON_STARTUP = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "loadOnStartup");
    public static final CdProperty AUTO_CLEANUP_TABLE_COLUMNS = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "autoCleanUpTableColumns");
    public static final CdProperty ACTIVATE_INCREMENTAL_LOAD = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "activateIncrementalLoad");
    public static final CdProperty USE_UNKNOWN_MEMBERS_IN_FACTS = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "useUnknownMembersInFacts");
    public static final CdProperty DISTINCT_COUNT_OPTIM = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "distinctCountOptim");
    public static final CdProperty STORAGE_POLICY = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "storagePolicy");
    public static final CdProperty HIERARCHY_UNIQUE_NAME_STYLE = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "hierarchyUniqueNameStyle");
    public static final CdProperty CACHE_TABLE = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "cacheTable");
    public static final CdProperty USE_FACT_PARTITIONING = new CdReadProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "useFactPartitioning");
    public static final CdProperty CALL_GARBAGE_COLLECTOR = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "callGarbageCollector");
    public static final CdProperty BACKUP = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "backup");
    public static final CdProperty DISABLE_AUTO_ATTRIBUTES = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "disableAutoAttributes");
    public static final CdProperty NON_EMPTY_CACHE_POLICY = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "nonEmptyCachePolicy");
    public static final CdProperty NON_EMPTY_CACHE_TYPE = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "nonEmptyCacheType");
    public static final CdProperty NON_EMPTY_CACHE_PERSISTENCY = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "nonEmptyCachePersistency");
    public static final CdProperty FACTORY_FILE = new CdReadProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "xmlFile");
    public static final CdProperty LOCALE_FOR_STRING_COMPARE = new CdReadProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "localeForStringCompare");
    public static final CdProperty SCHEMA_LOCALIZATION_FALLBACK_LOCALE = new CdReadWriteProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "schemaLocalizationFallbackLocale");
    public static final CdProperty MEMBERS_UPPER_LOWER_CASE_STRATEGY = new CdReadProperty(OlapBuilderCubeBasedSchemaDefFactory.class, "membersUpperLowerCaseStrategy");
    @XmlElement(name="cubeFactories", required=true)
    private final OlapBuilderCubeDefFactories cubeFactories;
    @XmlElement(name="schemaName", required=true)
    private String schemaName;
    @XmlElement(name="schemaDescription", required=true)
    private String schemaDescription;
    @XmlElement(name="schemaGroup", required=true)
    private String schemaGroup;
    @XmlElement(name="loadOnStartup", required=false)
    private boolean loadOnStartup = true;
    @XmlElement(name="upperLowerCaseStrategy", required=false)
    private MembersUpperLowerStrategyType membersUpperLowerCaseStrategy;
    @XmlElement(name="activateIncrementalLoad", required=false)
    private boolean activateIncrementalLoad;
    @XmlElement(name="acceptSpaceAsMemberName", required=false)
    private boolean acceptSpaceAsMemberName;
    @XmlElement(name="autoCleanUpTableColumns", required=true)
    private boolean autoCleanUpTableColumns;
    @XmlElement(name="useUnknownMembersInFacts", required=false)
    private boolean useUnknownMembersInFacts;
    @XmlElement(name="callGarbageCollector", required=false)
    private SchemaGarbageCollectorType callGarbageCollector;
    @XmlElement(name="memberPropertyConsistencyCheck", required=false)
    private MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck;
    @XmlElement(name="backup", required=false)
    private BackupType backup;
    @XmlElement(name="disableAutoAttributes", required=false)
    private Boolean disableAutoAttributes;
    @XmlElement(name="nonEmptyCachePolicy", required=false)
    private NonEmptyCachePolicy nonEmptyCachePolicy;
    @XmlElement(name="nonEmptyCacheType", required=false)
    private NonEmptyCacheType nonEmptyCacheType;
    @XmlElement(name="nonEmptyCachePersistency", required=false)
    private NonEmptyCachePersistency nonEmptyCachePersistency;
    @XmlElement(name="distinctCountOptim", required=false)
    private DistinctCountOptimType distinctCountOptim;
    @XmlElement(name="storagePolicy")
    private OlapBuilderStoragePolicy storagePolicy;
    @XmlElement(name="mmapFacts", required=false)
    private boolean _mmapFacts;
    @XmlElement(name="cacheTable", required=false)
    @Nullable
    private Boolean cacheTable;
    @XmlElement(name="useFactPartitioning", required=false)
    private boolean useFactPartitioning;
    @XmlElement(name="hierarchyUniqueNameStyle", required=false)
    private OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle;
    @XmlElement(name="mergeToSchema", required=false)
    @Nullable
    private String _mergeToSchema;
    @XmlElement(name="reverseLink", required=false)
    @Nullable
    private Boolean reverseLink;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="localForStringCompare", required=false)
    @Nullable
    private Locale localForStringCompare;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="schemaLocalizationFallbackLocale", required=false)
    @Nullable
    private Locale schemaLocalizationFallbackLocale;

    public OlapBuilderCubeBasedSchemaDefFactory() {
        this.cubeFactories = new OlapBuilderCubeDefFactories();
    }

    public OlapBuilderCubeBasedSchemaDefFactory(String schemaName, String schemaDescription, String schemaGroup, IOlapBuilderCubeDefFactory ... cubeDefinitionFactories) {
        this.schemaName = schemaName;
        this.schemaDescription = schemaDescription;
        this.schemaGroup = schemaGroup;
        this.cubeFactories = new OlapBuilderCubeDefFactories();
        this.cubeFactories.add(cubeDefinitionFactories);
    }

    public OlapBuilderCubeBasedSchemaDefFactory(String schemaName, String schemaDescription, String schemaGroup, OlapBuilderCubeDefFactories cubeDefinitionFactories) {
        this.schemaName = schemaName;
        this.schemaDescription = schemaDescription;
        this.schemaGroup = schemaGroup;
        this.cubeFactories = cubeDefinitionFactories;
    }

    @Override
    public boolean isCubeBased() {
        return true;
    }

    @Override
    public String getName() {
        return this.getSchemaName();
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSchemaDescription() {
        return this.schemaDescription;
    }

    @Override
    public String getSchemaGroup() {
        return this.schemaGroup;
    }

    @Override
    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    @Override
    public boolean incrementalLoadActive() {
        return this.activateIncrementalLoad;
    }

    @Override
    public boolean isAcceptSpaceAsMemberName() {
        return this.acceptSpaceAsMemberName;
    }

    @Override
    public MembersUpperLowerStrategyType membersUpperLowerCaseStrategy() {
        return this.membersUpperLowerCaseStrategy;
    }

    @Override
    public DistinctCountOptimType getDistinctCountOptim() {
        return this.distinctCountOptim;
    }

    @Nullable
    public IOlapBuilderCubeDefFactory getCubeFactory(final String name) {
        return (IOlapBuilderCubeDefFactory)CdCollections.findFirst(this.cubeFactories.getFactories(), (CdFilter)new CdFilter<IOlapBuilderCubeDefFactory>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(IOlapBuilderCubeDefFactory cubeFactory) {
                return cubeFactory.getCubeName().equals(name);
            }
        });
    }

    @Override
    public IOlapBuilderSchemaDef getSchemaDefinition() {
        return null;
    }

    @Override
    public IOlapBuilderSchemaDef createSchemaDefinition(final OlapBuilderConnectionPool connectionPool, final OlapBuilderErrorManager errorManager) {
        final OlapBuilderSchema schema = new OlapBuilderSchema(this.schemaName, this.schemaDescription, this.schemaGroup, this.autoCleanUpTableColumns, this.activateIncrementalLoad);
        final MutableBoolean hasValidationError = new MutableBoolean();
        CdCollections.apply(this.cubeFactories.getFactories(), (CdAction)new CdAction<IOlapBuilderCubeDefFactory>(){
            {
                Objects.requireNonNull(this$0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(IOlapBuilderCubeDefFactory cubeFactory) {
                errorManager.pushContext(cubeFactory);
                try {
                    IOlapBuilderHeaderCubeDef cubeDef = cubeFactory.createCubeDefinition(connectionPool, errorManager);
                    schema.addCube(cubeDef);
                    schema.addDimensions(cubeDef.getDimensions());
                    List<IOlapBuilderCalcMemberDef> calcMembers = cubeDef.getCalcMembers();
                    if (calcMembers != null && !calcMembers.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (IOlapBuilderCalcMemberDef calcMember : calcMembers) {
                            calcMember.asCreateStatement(sb, null);
                            sb.append("\n");
                        }
                        schema.setScript(sb.toString());
                    }
                }
                catch (OlapBuilderErrorException ex) {
                    errorManager.addError(ex.getError());
                    hasValidationError.setValue(true);
                }
                catch (RuntimeException ex) {
                    errorManager.addException(ex);
                    hasValidationError.setValue(true);
                }
                finally {
                    errorManager.popContext();
                }
            }
        });
        if (hasValidationError.booleanValue()) {
            throw new RuntimeException("marker:cube-def-factory-validation-error(s)");
        }
        return schema;
    }

    @Override
    public File getXmlFile() {
        return this.xmlFile;
    }

    @Override
    @XmlTransient
    public void setXmlFile(final File xmlFile) {
        super.setXmlFile(xmlFile);
        CdCollections.apply(this.cubeFactories.getFactories(), (CdAction)new CdAction<IOlapBuilderCubeDefFactory>(){
            {
                Objects.requireNonNull(this$0);
            }

            public void apply(IOlapBuilderCubeDefFactory cubeFactory) {
                cubeFactory.setXmlFile(xmlFile);
            }
        });
    }

    public OlapBuilderCubeDefFactories getCubeFactories() {
        return this.cubeFactories;
    }

    public void addCubeFactory(IOlapBuilderCubeDefFactory cubeFactory) {
        this.cubeFactories.add(cubeFactory);
    }

    public boolean removeCubeFactory(IOlapBuilderCubeDefFactory cubeFactory) {
        return this.cubeFactories.remove(cubeFactory);
    }

    @Override
    public boolean useUnknownMembersInFacts() {
        return this.useUnknownMembersInFacts;
    }

    @Override
    public OlapBuilderStoragePolicy getStoragePolicy() {
        if (this.storagePolicy == null && this._mmapFacts) {
            return OlapBuilderStoragePolicy.FACTS_IN_FILES;
        }
        return this.storagePolicy == null ? OlapBuilderStoragePolicy.DEFAULT : this.storagePolicy;
    }

    @Override
    public boolean isCacheTable() {
        return this.cacheTable != null ? this.cacheTable : false;
    }

    @Override
    public boolean useFactPartitioning() {
        return this.useFactPartitioning;
    }

    @Override
    public SchemaGarbageCollectorType callGarbageCollector() {
        return this.callGarbageCollector == null ? SchemaGarbageCollectorType.NONE : this.callGarbageCollector;
    }

    @Override
    public MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck() {
        return this.memberPropertyConsistencyCheck == null ? MemberPropertyConsistencyCheckType.NONE : this.memberPropertyConsistencyCheck;
    }

    @Override
    public BackupType backup() {
        return this.backup == null ? BackupType.NONE : this.backup;
    }

    @Override
    public boolean disableAutoAttributes() {
        return this.disableAutoAttributes != null && this.disableAutoAttributes != false;
    }

    @Override
    public NonEmptyCachePolicy nonEmptyCachePolicy() {
        return this.nonEmptyCachePolicy == null ? NonEmptyCachePolicy.NONE : this.nonEmptyCachePolicy;
    }

    @Override
    public NonEmptyCacheType nonEmptyCacheType() {
        return this.nonEmptyCacheType == null ? NonEmptyCacheType.REGULAR : this.nonEmptyCacheType;
    }

    @Override
    public NonEmptyCachePersistency nonEmptyCachePersistency() {
        return this.nonEmptyCachePersistency == null ? NonEmptyCachePersistency.MEMORY : this.nonEmptyCachePersistency;
    }

    @Override
    public OlapBuilderHierarchyUniqueNameStyle getHierarchyUniqueNameStyle() {
        return this.hierarchyUniqueNameStyle == null ? OlapBuilderHierarchyUniqueNameStyle.IncludeDimensionName : this.hierarchyUniqueNameStyle;
    }

    @Override
    @Nullable
    public Locale getLocaleForStringCompare() {
        return this.localForStringCompare;
    }

    @Override
    @Nullable
    public Locale getSchemaLocalizationFallbackLocale() {
        return this.schemaLocalizationFallbackLocale;
    }

    @Override
    public boolean enableReverseLink() {
        return this.reverseLink == Boolean.TRUE;
    }
}

