/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.rowreading;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorService;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;

public class OlapBuilderTableRowReadingThreadPoolExecutorService
extends OlapThreadPoolExecutorService<OlapBuilderContext> {
    public OlapBuilderTableRowReadingThreadPoolExecutorService(int prefix, int threadCount) {
        super(prefix + "-tbl-read", threadCount);
    }

    @Override
    protected OlapThreadPoolExecutorService.ExecutingContext doCreateExecutingContext(String type, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, OlapBuilderContext context, int queueSize) {
        return new ReadingExecutingContext(type, schedulingPolicy, context, queueSize);
    }

    public static class ReadingExecutingContext
    extends OlapThreadPoolExecutorService.ExecutingContext<OlapBuilderContext> {
        ReadingExecutingContext(String type, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, OlapBuilderContext executionContext, int queueSize) {
            super(type, schedulingPolicy, executionContext, queueSize);
        }

        @Override
        protected void reportResolvedException(OlapBuilderContext executionContext, Throwable error) {
            CdRuntimeException unexpected = this.createUnexpectedException(error);
            if (this.reportException(unexpected)) {
                OlapLoggers.BUILDER_TABLE.error((Object)"table reading unexpected exception", (Throwable)unexpected);
            }
        }

        @Override
        protected void reportResolvedRuntimeException(OlapBuilderContext executionContext, RuntimeException error) {
            CdRuntimeException unexpected = this.createUnexpectedException(error);
            if (this.reportException(unexpected)) {
                OlapLoggers.BUILDER_TABLE.error((Object)"table reading unexpected exception", (Throwable)unexpected);
            }
        }

        @Override
        protected void reportResolvedCdRuntimeException(OlapBuilderContext executionContext, CdRuntimeException error) {
            if (error instanceof OlapBuilderErrorException) {
                if (this.reportException(error)) {
                    OlapLoggers.BUILDER_TABLE.error((Object)"table reading exception", (Throwable)error);
                }
            } else {
                CdRuntimeException unexpected = this.createUnexpectedException(error);
                if (this.reportException(unexpected)) {
                    OlapLoggers.BUILDER_TABLE.error((Object)"table reading unexpected exception", (Throwable)unexpected);
                }
            }
        }

        private CdRuntimeException createUnexpectedException(Throwable error) {
            return new OlapBuilderErrorException(error, OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{error.toString()});
        }
    }
}

