/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.rowreading;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTask;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskFactory;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingThreadPoolExecutorService;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorServiceListener;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskExecutor;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableRowReadingTaskExecutor {
    private static final AtomicInteger count = new AtomicInteger();
    @Nullable
    final OlapBuilderTableRowReadingThreadPoolExecutorService service;
    private final int singleLoadReadingQueueSize;

    public OlapBuilderTableRowReadingTaskExecutor(boolean asyncReadLicensed, OlapProperties properties) {
        boolean async;
        count.incrementAndGet();
        int threadCount = properties.getLoadReadingThreadCount();
        boolean bl = async = asyncReadLicensed && threadCount > 0;
        if (async) {
            int serviceThreadCount = threadCount;
            this.service = new OlapBuilderTableRowReadingThreadPoolExecutorService(count.get(), serviceThreadCount);
            this.singleLoadReadingQueueSize = properties.getLoadReadingQueueSize();
            if (OlapLoggers.GENERAL.isInfoEnabled()) {
                OlapLoggers.GENERAL.info((Object)("[builder-reading-executor   ] count        : " + count.get()));
                OlapLoggers.GENERAL.info((Object)("[builder-reading-executor   ] load request : " + properties.getActiveLoadCount()));
                OlapLoggers.GENERAL.info((Object)("[builder-reading-executor   ] thread count : " + serviceThreadCount));
                OlapLoggers.GENERAL.info((Object)("[builder-reading-executor   ] queue size   : " + this.singleLoadReadingQueueSize));
                OlapLoggers.GENERAL.info((Object)("[builder-reading-executor   ] batch size   : " + properties.getLoadReadingRowBatch()));
            }
        } else {
            this.service = null;
            this.singleLoadReadingQueueSize = -1;
            if (OlapLoggers.GENERAL.isInfoEnabled()) {
                OlapLoggers.GENERAL.info((Object)"[builder-reading-executor   ] thread count : sequential");
            }
        }
    }

    public int getQueuedTaskCount() {
        return this.service == null ? -1 : this.service.getQueuedTaskCount();
    }

    public boolean isAsynchronous() {
        return this.service != null;
    }

    public void shutdownNow() {
        count.decrementAndGet();
        if (OlapLoggers.GENERAL.isInfoEnabled()) {
            OlapLoggers.GENERAL.info((Object)("[builder-reading-executor   ] shutdown requested (" + count.get() + ")"));
        }
        if (this.service != null) {
            this.service.shutdownNow();
        }
        if (OlapLoggers.GENERAL.isInfoEnabled()) {
            OlapLoggers.GENERAL.info((Object)"[builder-reading-executor   ] bye");
        }
    }

    public void process(OlapBuilderContext context, OlapBuilderTableRowReadingTaskFactory tasks) {
        if (this.service == null) {
            this.processSequential(context, tasks);
        } else {
            this.processAsynchronous(context, tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSequential(OlapBuilderContext context, OlapBuilderTableRowReadingTaskFactory tasks) {
        Logger logger = context.getLoggers().builderTable();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"table(s) seq. reading task started");
        }
        try {
            OlapBuilderTableRowReadingTask task;
            tasks.init();
            while ((task = tasks.next()) != null) {
                OlapThreadPoolExecutorTaskExecutor.execute(task);
            }
        }
        finally {
            tasks.done();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"table(s) seq. reading task completed");
            }
        }
    }

    private void processAsynchronous(OlapBuilderContext context, OlapBuilderTableRowReadingTaskFactory tasks) {
        if (this.service == null) {
            throw new RuntimeException("internal error: missing builder reading service");
        }
        Logger logger = context.getLoggers().builderTable();
        this.service.processTasks(context, this.singleLoadReadingQueueSize, tasks, logger.isDebugEnabled() ? new LoggingListener(logger) : IOlapThreadPoolExecutorServiceListener.EMPTY_LISTENER);
    }

    private static class LoggingListener
    implements IOlapThreadPoolExecutorServiceListener {
        private final Logger logger;

        public LoggingListener(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void onProcessTasksStarted() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"table(s) async. reading task started");
            }
        }

        @Override
        public void onWaitingForTaskProcessingCompletion(int taskCount) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("table(s) async. waiting for reading task completed (" + taskCount + ")"));
            }
        }

        @Override
        public void onWaitingForTaskProcessingCompleted() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"table(s) async.waiting for reading task completed done");
            }
        }

        @Override
        public void onProcessTasksCompleted() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"table(s) async. reading task completed");
            }
        }

        @Override
        public void onNextTaskException(RuntimeException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"table(s) async. reading task generation error", (Throwable)ex);
            }
        }
    }
}

