/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.rowprocessing;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableResolvedRow;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRowBatch;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingInfo;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTask;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTaskExecutor;
import crazydev.iccube.builder.executor.rowprocessing.task.OlapBuilderTableBatchRowProcessingTask;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskInfo;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.browsing.IOlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorTaskFactory;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableRowProcessingTaskFactory<CONNECTION extends IOlapBuilderConnection>
implements IOlapThreadPoolExecutorTaskFactory {
    private static final double PERIOD_ROW_COUNT = 100000.0;
    private final OlapBuilderContext context;
    @Nullable
    private final IOlapBuilderBrowsingDataTableInfo browsingInfo;
    private final IOlapBuilderTableRowReader<CONNECTION> rowReader;
    private final OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy;
    private final IOlapBuilderDataTableDef<CONNECTION> table;
    private final OlapBuilderTableProcessingInfo tableInfo;
    private final int batchSize;
    private boolean hasSetupStartTimeMS;
    private long startMS;
    private long count;
    private long periodStartMS;

    public OlapBuilderTableRowProcessingTaskFactory(OlapBuilderContext context, OlapBuilderTableRowReadingTaskInfo<CONNECTION> rowReaderInfo, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        this.context = context;
        this.rowReader = rowReaderInfo.getTableReader();
        this.processingSchedulingPolicy = rowReaderInfo.getProcessingSchedulingPolicy();
        this.browsingInfo = browsingInfo;
        this.table = this.rowReader.getTable();
        this.tableInfo = rowReaderInfo.getTableInfo();
        if (browsingInfo == null) {
            OlapProperties properties = context.getEngineContext().getOlapEngineProperties();
            this.batchSize = properties.getLoadReadingRowBatch();
        } else {
            this.batchSize = 1;
        }
        this.hasSetupStartTimeMS = false;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public String getRowReaderName() {
        return this.rowReader.getName();
    }

    @Override
    public OlapThreadPoolExecutorTaskSchedulingPolicy getSchedulingPolicy() {
        return this.processingSchedulingPolicy;
    }

    @Override
    public void init() {
        this.startMS = System.currentTimeMillis();
        this.count = 0L;
        this.periodStartMS = this.startMS;
        this.tableInfo.onTablePartitionReadStarted(this.context, this.rowReader);
        this.rowReader.init();
    }

    @Nullable
    public final OlapBuilderTableRowProcessingTask next() {
        if (this.context.isCancelling()) {
            return null;
        }
        if (!this.hasSetupStartTimeMS) {
            this.startMS = System.currentTimeMillis();
            this.hasSetupStartTimeMS = true;
        }
        return this.nextTask();
    }

    @Override
    public void done() {
        boolean tableDone;
        Logger logger;
        IOlapBuilderTablePartitionKey tablePartitionKey;
        this.rowReader.done();
        this.tableInfo.onTablePartitionProcessingCompleted(this.context, this.rowReader);
        boolean factsProcessing = this.context.isForFactsProcessing();
        boolean canFireTableRowsProcessingCompleted = true;
        if (factsProcessing && (tablePartitionKey = this.rowReader.getPartitionKey()) != null && this.isFactsTablePartitioned()) {
            logger = this.context.getLoggers().builderTable();
            logger.info((Object)"table [%s] facts rows processing completed [partition:%s] (notification)".formatted(this.table.getName(), tablePartitionKey));
            this.table.onTableRowsProcessingCompleted(this.context, tablePartitionKey);
            logger.info((Object)"table [%s] facts rows processing completed [partition:%s] (done)".formatted(this.table.getName(), tablePartitionKey));
            canFireTableRowsProcessingCompleted = false;
        }
        if (tableDone = this.tableInfo.onTableRowProcessingDone(this.rowReader)) {
            OlapLoggers.BUILDER.info((Object)"table [%s] processing completed ".formatted(this.table.getName()));
            this.tableInfo.onTableProcessingCompleted(this.context);
        }
        if (factsProcessing && tableDone && canFireTableRowsProcessingCompleted) {
            logger = this.context.getLoggers().builderTable();
            logger.info((Object)"table [%s] facts rows processing completed (notification)".formatted(this.table.getName()));
            this.table.onTableRowsProcessingCompleted(this.context);
            logger.info((Object)"table [%s] facts rows processing completed (done)".formatted(this.table.getName()));
        }
    }

    private boolean isFactsTablePartitioned() {
        if (this.table.isView()) {
            return false;
        }
        HashSet listeners = new HashSet();
        this.table.forEachListener((CdAction<IOlapBuilderTableListener>)((CdAction)listener -> {
            if (listener instanceof OlapBuilderFactBuilder) {
                OlapBuilderFactBuilder facts = (OlapBuilderFactBuilder)listener;
                listeners.add(facts);
            }
        }));
        if (listeners.size() == 1) {
            Optional facts = listeners.stream().findFirst();
            return ((OlapBuilderFactBuilder)facts.get()).isTablePartitioned();
        }
        return false;
    }

    @Nullable
    protected OlapBuilderTableRowProcessingTask nextTask() {
        OlapBuilderTableRowProcessingTask task = this.doNextTask();
        if (task == null) {
            long elapsedMS = System.currentTimeMillis() - this.startMS;
            int speed = (int)((double)this.count * 1000.0 / (double)elapsedMS);
            OlapBuilderTableRowProcessingTaskExecutor processingExecutor = this.context.getBuilderProcessingExecutor();
            int queuedTaskCount = processingExecutor.getQueuedTaskCount();
            long queueTaskSize = processingExecutor.getQueueTaskSize();
            this.tableInfo.onTablePartitionReadProgress(this.context, this.rowReader, this.count, speed, queuedTaskCount, queueTaskSize);
            this.tableInfo.onTablePartitionReadCompleted(this.context, this.rowReader, this.count);
            Logger logger = this.context.getLoggers().builderTable();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("table [%s] [ partition : %s ] has read %s total rows [ rows/sec : %s ]", this.table.getName(), this.rowReader.getName(), CdStringUtils.formatNice((long)this.count), CdStringUtils.formatNice((long)speed)));
            }
        }
        return task;
    }

    @Nullable
    private OlapBuilderTableRowProcessingTask doNextTask() {
        if (this.browsingInfo != null && this.browsingInfo.isDone()) {
            return null;
        }
        try {
            IOlapBuilderTableRow row;
            OlapBuilderTableRowProcessingTaskExecutor processingExecutor = this.context.getBuilderProcessingExecutor();
            OlapBuilderTableRowBatch batch = null;
            while ((row = this.rowReader.nextRow()) != null) {
                this.onNextRow(processingExecutor);
                if (row.isEmpty() || (batch = !this.rowReader.isRowSafe() ? this.addRowToBatch(batch, OlapBuilderTableRowProcessingTaskFactory.createShareableRow(this.table.getAllColumns(), row)) : this.addRowToBatch(batch, row)).size() < this.batchSize) continue;
                return new OlapBuilderTableBatchRowProcessingTask<CONNECTION>(this.context, this.table, this.rowReader.getFullTableNameForEndUser(), this.rowReader.getPartitionKey(), batch);
            }
            if (batch != null && !batch.isEmpty()) {
                return new OlapBuilderTableBatchRowProcessingTask<CONNECTION>(this.context, this.table, this.rowReader.getFullTableNameForEndUser(), this.rowReader.getPartitionKey(), batch);
            }
            return null;
        }
        catch (CdRuntimeException ex) {
            if (ex instanceof OlapBuilderErrorException && ((OlapBuilderErrorException)ex).isIgnoreDataLine()) {
                throw ex;
            }
            OlapLoggers.BUILDER_TABLE.error((Object)"table row error", (Throwable)ex);
            OlapBuilderError error = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.LINE_TABLE_ON_PROCESS_LINE, new Serializable[]{this.rowReader.getFullTableNameForEndUser(), this.rowReader.rowNumberForEndUser()});
            throw new OlapBuilderErrorException((Throwable)ex, error);
        }
    }

    private OlapBuilderTableRowBatch addRowToBatch(@Nullable OlapBuilderTableRowBatch batch, IOlapBuilderTableRow row) {
        if (batch == null) {
            batch = new OlapBuilderTableRowBatch(this.rowReader.rowNb());
        }
        batch.addRow(row);
        return batch;
    }

    public static IOlapBuilderTableRow createShareableRow(List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow row) {
        Comparable[] values = new Comparable[columns.size()];
        for (IOlapBuilderDataColumnDef column : columns) {
            if (!column.isForTableSelect()) continue;
            values[column.getIndex()] = row.getJavaNativeDataValue(column);
        }
        return new OlapBuilderTableResolvedRow(values);
    }

    private void onNextRow(OlapBuilderTableRowProcessingTaskExecutor processingExecutor) {
        if ((double)(++this.count) % 100000.0 == 0.0) {
            long elapsedMS = System.currentTimeMillis() - this.startMS;
            int speed = (int)((double)this.count * 1000.0 / (double)elapsedMS);
            long periodMS = System.currentTimeMillis() - this.periodStartMS;
            int periodSpeed = (int)(1.0E8 / (double)periodMS);
            int queuedTaskCount = processingExecutor.getQueuedTaskCount();
            long queueTaskSize = processingExecutor.getQueueTaskSize();
            this.tableInfo.onTablePartitionReadProgress(this.context, this.rowReader, this.count, periodSpeed, queuedTaskCount, queueTaskSize);
            Logger logger = this.context.getLoggers().builderTable();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("table [%s] [ partition : %s ] has read %s rows [ rows/sec (t) : %s ] [ rows/sec (i) : %s ] [ processing-queue : %d / %d ]", this.table.getName(), this.rowReader.getName(), CdStringUtils.formatNice((long)this.count), CdStringUtils.formatNice((long)speed), CdStringUtils.formatNice((long)periodSpeed), queuedTaskCount, queueTaskSize));
            }
            this.periodStartMS = System.currentTimeMillis();
        }
    }
}

