/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.rowprocessing;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTask;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTaskFactory;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingThreadPoolExecutorService;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorServiceListener;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskExecutor;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableRowProcessingTaskExecutor {
    private static final AtomicInteger count = new AtomicInteger();
    private final int singleLoadProcessingQueueSize;
    @Nullable
    private final OlapBuilderTableRowProcessingThreadPoolExecutorService service;

    public OlapBuilderTableRowProcessingTaskExecutor(boolean asyncProcLicensed, OlapProperties properties) {
        boolean async;
        count.incrementAndGet();
        int threadCount = properties.getLoadProcessingThreadCount();
        boolean bl = async = asyncProcLicensed && threadCount > 0;
        if (async) {
            int serviceThreadCount = threadCount;
            this.service = new OlapBuilderTableRowProcessingThreadPoolExecutorService(count.get(), serviceThreadCount);
            this.singleLoadProcessingQueueSize = properties.getLoadProcessingQueueSize();
            if (OlapLoggers.GENERAL.isInfoEnabled()) {
                OlapLoggers.GENERAL.info((Object)("[builder-processing-executor] count        : " + count.get()));
                OlapLoggers.GENERAL.info((Object)("[builder-processing-executor] thread count : " + serviceThreadCount));
                OlapLoggers.GENERAL.info((Object)("[builder-processing-executor] queue size   : " + this.singleLoadProcessingQueueSize));
            }
        } else {
            this.service = null;
            this.singleLoadProcessingQueueSize = -1;
            if (OlapLoggers.GENERAL.isInfoEnabled()) {
                OlapLoggers.GENERAL.info((Object)"[builder-processing-executor] thread count : sequential");
            }
        }
    }

    public void shutdownNow() {
        count.decrementAndGet();
        if (OlapLoggers.GENERAL.isInfoEnabled()) {
            OlapLoggers.GENERAL.info((Object)("[builder-processing-executor] shutdown requested (" + count.get() + ")"));
        }
        if (this.service != null) {
            this.service.shutdownNow();
        }
        if (OlapLoggers.GENERAL.isInfoEnabled()) {
            OlapLoggers.GENERAL.info((Object)"[builder-processing-executor] bye");
        }
    }

    public long getQueueTaskSize() {
        return this.singleLoadProcessingQueueSize;
    }

    public int getQueuedTaskCount() {
        return this.service == null ? -1 : this.service.getQueuedTaskCount();
    }

    public boolean isAsynchronous() {
        return this.service != null;
    }

    public void process(OlapBuilderContext context, OlapBuilderTableRowProcessingTaskFactory tasks) {
        if (this.service == null) {
            this.processSequential(context, tasks);
        } else {
            this.processAsynchronous(context, tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSequential(OlapBuilderContext context, OlapBuilderTableRowProcessingTaskFactory tasks) {
        String tableName = tasks.getTableName();
        String rowReaderName = tasks.getRowReaderName();
        Logger logger = context.getLoggers().builderTable();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("table [" + tableName + "] [ partition : " + rowReaderName + " ] seq. processing task started"));
        }
        try {
            OlapBuilderTableRowProcessingTask task;
            tasks.init();
            while ((task = tasks.next()) != null) {
                OlapThreadPoolExecutorTaskExecutor.execute(task);
            }
        }
        finally {
            tasks.done();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("table [" + tableName + "] [ partition : " + rowReaderName + " ] seq. processing task completed"));
            }
        }
    }

    private void processAsynchronous(OlapBuilderContext context, OlapBuilderTableRowProcessingTaskFactory tasks) {
        if (this.service == null) {
            throw new RuntimeException("internal error: missing builder processing service");
        }
        String tableName = tasks.getTableName();
        String rowReaderName = tasks.getRowReaderName();
        this.service.processTasks(context, this.singleLoadProcessingQueueSize, tasks, new LoggingListener(context, tableName, rowReaderName));
        if (context.getLoggers().builderTable().isDebugEnabled()) {
            context.getLoggers().builderTable().debug((Object)("table [" + tasks.getTableName() + "] [ partition : " + rowReaderName + " ] async. processing task done"));
        }
    }

    static class LoggingListener
    implements IOlapThreadPoolExecutorServiceListener {
        final OlapBuilderContext context;
        final String tableName;
        final String rowReaderName;

        LoggingListener(OlapBuilderContext context, String tableName, String rowReaderName) {
            this.context = context;
            this.tableName = tableName;
            this.rowReaderName = rowReaderName;
        }

        @Override
        public void onProcessTasksStarted() {
            if (this.context.getLoggers().builderTable().isDebugEnabled()) {
                this.context.getLoggers().builderTable().debug((Object)("table [" + this.tableName + "] [ partition : " + this.rowReaderName + " ] async. processing task started"));
            }
        }

        @Override
        public void onWaitingForTaskProcessingCompletion(int taskCount) {
            if (this.context.getLoggers().builderTable().isDebugEnabled()) {
                this.context.getLoggers().builderTable().debug((Object)("table [" + this.tableName + "] [ partition : " + this.rowReaderName + " ] async. waiting for processing task completed (" + taskCount + ")"));
            }
        }

        @Override
        public void onWaitingForTaskProcessingCompleted() {
            if (this.context.getLoggers().builderTable().isDebugEnabled()) {
                this.context.getLoggers().builderTable().debug((Object)("table [" + this.tableName + "] [ partition : " + this.rowReaderName + " ] async. waiting for processing task completed done"));
            }
        }

        @Override
        public void onProcessTasksCompleted() {
            if (this.context.getLoggers().builderTable().isDebugEnabled()) {
                this.context.getLoggers().builderTable().debug((Object)("table [" + this.tableName + "] [ partition : " + this.rowReaderName + " ] async. processing task completed"));
            }
        }

        @Override
        public void onNextTaskException(RuntimeException ex) {
            if (this.context.getLoggers().builderTable().isDebugEnabled()) {
                this.context.getLoggers().builderTable().debug((Object)("table [" + this.tableName + "] [ partition : " + this.rowReaderName + " ] async. processing task generation error"), (Throwable)ex);
            }
        }
    }
}

