/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.pool;

import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTaskExecutor;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskExecutor;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableExecutorPool {
    private final LinkedList<OlapBuilderTableRowReadingTaskExecutor> readingTaskExecutors = new LinkedList();
    private final LinkedList<OlapBuilderTableRowProcessingTaskExecutor> processingTaskExecutors = new LinkedList();
    private final LinkedList<OlapBuilderTableRowReadingTaskExecutor> readingTaskExecutorsForTableBrowsing = new LinkedList();
    private final LinkedList<OlapBuilderTableRowProcessingTaskExecutor> processingTaskExecutorsForTableBrowsing = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLoadingQueuedTaskCount() {
        LinkedList<OlapBuilderTableRowReadingTaskExecutor> linkedList = this.readingTaskExecutors;
        synchronized (linkedList) {
            long count = 0L;
            for (OlapBuilderTableRowReadingTaskExecutor readingTaskExecutor : this.readingTaskExecutors) {
                count += (long)readingTaskExecutor.getQueuedTaskCount();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getProcessingQueuedTaskCount() {
        LinkedList<OlapBuilderTableRowProcessingTaskExecutor> linkedList = this.processingTaskExecutors;
        synchronized (linkedList) {
            long count = 0L;
            for (OlapBuilderTableRowProcessingTaskExecutor processingTaskExecutor : this.processingTaskExecutors) {
                count += (long)processingTaskExecutor.getQueuedTaskCount();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        if (OlapLoggers.GENERAL.isInfoEnabled()) {
            OlapLoggers.GENERAL.info((Object)"builder-table-executor pool shutdown requested");
        }
        LinkedList<Object> linkedList = this.readingTaskExecutors;
        synchronized (linkedList) {
            for (OlapBuilderTableRowReadingTaskExecutor readingTaskExecutor : this.readingTaskExecutors) {
                try {
                    readingTaskExecutor.shutdownNow();
                }
                catch (RuntimeException ignored) {
                    OlapLoggers.BUILDER.warn((Object)"[builder] could not properly shutdown a builder-reading-executor", (Throwable)ignored);
                }
            }
            this.readingTaskExecutors.clear();
        }
        linkedList = this.readingTaskExecutorsForTableBrowsing;
        synchronized (linkedList) {
            for (OlapBuilderTableRowReadingTaskExecutor readingTaskExecutor : this.readingTaskExecutorsForTableBrowsing) {
                try {
                    readingTaskExecutor.shutdownNow();
                }
                catch (RuntimeException ignored) {
                    OlapLoggers.BUILDER.warn((Object)"[builder] could not properly shutdown a builder-reading-executor", (Throwable)ignored);
                }
            }
            this.readingTaskExecutorsForTableBrowsing.clear();
        }
        linkedList = this.processingTaskExecutors;
        synchronized (linkedList) {
            for (OlapBuilderTableRowProcessingTaskExecutor processingTaskExecutor : this.processingTaskExecutors) {
                try {
                    processingTaskExecutor.shutdownNow();
                }
                catch (RuntimeException ignored) {
                    OlapLoggers.BUILDER.warn((Object)"[builder] could not properly shutdown a builder-processing-executor", (Throwable)ignored);
                }
            }
            this.processingTaskExecutors.clear();
        }
        linkedList = this.processingTaskExecutorsForTableBrowsing;
        synchronized (linkedList) {
            for (OlapBuilderTableRowProcessingTaskExecutor processingTaskExecutor : this.processingTaskExecutorsForTableBrowsing) {
                try {
                    processingTaskExecutor.shutdownNow();
                }
                catch (RuntimeException ignored) {
                    OlapLoggers.BUILDER.warn((Object)"[builder] could not properly shutdown a builder-processing-executor", (Throwable)ignored);
                }
            }
            this.processingTaskExecutorsForTableBrowsing.clear();
        }
        if (OlapLoggers.GENERAL.isInfoEnabled()) {
            OlapLoggers.GENERAL.info((Object)"builder-table-executor pool shutdown done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapBuilderTableRowReadingTaskExecutor getOrCreateTableReadingTaskExecutor(boolean asyncReadLicensed, OlapProperties engineProperties) {
        LinkedList<OlapBuilderTableRowReadingTaskExecutor> linkedList = this.readingTaskExecutors;
        synchronized (linkedList) {
            if (this.readingTaskExecutors.isEmpty()) {
                return new OlapBuilderTableRowReadingTaskExecutor(asyncReadLicensed, engineProperties);
            }
            return this.readingTaskExecutors.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapBuilderTableRowReadingTaskExecutor getOrCreateTableReadingTaskExecutorForTableBrowsing(OlapProperties engineProperties) {
        LinkedList<OlapBuilderTableRowReadingTaskExecutor> linkedList = this.readingTaskExecutorsForTableBrowsing;
        synchronized (linkedList) {
            if (this.readingTaskExecutorsForTableBrowsing.isEmpty()) {
                return new OlapBuilderTableRowReadingTaskExecutor(false, engineProperties);
            }
            return this.readingTaskExecutorsForTableBrowsing.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapBuilderTableRowProcessingTaskExecutor getOrCreateTableProcessingTaskExecutor(boolean asyncProcLicensed, OlapProperties engineProperties) {
        LinkedList<OlapBuilderTableRowProcessingTaskExecutor> linkedList = this.processingTaskExecutors;
        synchronized (linkedList) {
            if (this.processingTaskExecutors.isEmpty()) {
                return new OlapBuilderTableRowProcessingTaskExecutor(asyncProcLicensed, engineProperties);
            }
            return this.processingTaskExecutors.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapBuilderTableRowProcessingTaskExecutor getOrCreateTableProcessingTaskExecutorForTableBrowsing(OlapProperties engineProperties) {
        LinkedList<OlapBuilderTableRowProcessingTaskExecutor> linkedList = this.processingTaskExecutorsForTableBrowsing;
        synchronized (linkedList) {
            if (this.processingTaskExecutorsForTableBrowsing.isEmpty()) {
                return new OlapBuilderTableRowProcessingTaskExecutor(false, engineProperties);
            }
            return this.processingTaskExecutorsForTableBrowsing.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTableReadingTaskExecutor(@Nullable OlapBuilderTableRowReadingTaskExecutor executor) {
        if (executor != null) {
            LinkedList<OlapBuilderTableRowReadingTaskExecutor> linkedList = this.readingTaskExecutors;
            synchronized (linkedList) {
                this.readingTaskExecutors.push(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTableReadingTaskExecutorForTableBrowsing(@Nullable OlapBuilderTableRowReadingTaskExecutor executor) {
        if (executor != null) {
            LinkedList<OlapBuilderTableRowReadingTaskExecutor> linkedList = this.readingTaskExecutorsForTableBrowsing;
            synchronized (linkedList) {
                this.readingTaskExecutorsForTableBrowsing.push(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTableProcessingTaskExecutor(@Nullable OlapBuilderTableRowProcessingTaskExecutor executor) {
        if (executor != null) {
            LinkedList<OlapBuilderTableRowProcessingTaskExecutor> linkedList = this.processingTaskExecutors;
            synchronized (linkedList) {
                this.processingTaskExecutors.push(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTableProcessingTaskExecutorForTableBrowsing(@Nullable OlapBuilderTableRowProcessingTaskExecutor executor) {
        if (executor != null) {
            LinkedList<OlapBuilderTableRowProcessingTaskExecutor> linkedList = this.processingTaskExecutorsForTableBrowsing;
            synchronized (linkedList) {
                this.processingTaskExecutorsForTableBrowsing.push(executor);
            }
        }
    }
}

