/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss.lib;

import crazydev.iccube.builder.datasource.spss.lib.SpssInputStream;
import crazydev.iccube.builder.datasource.spss.lib.SpssVariableFormat;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpssVariable {
    static final int RECORD_TYPE = 2;
    private static final Charset ASCII = StandardCharsets.US_ASCII;
    private final int typeCode;
    private final SpssVariableFormat printFormat;
    private final SpssVariableFormat writeFormat;
    private final boolean numeric;
    private final int positionInRecord;
    private final SpssInputStream inputStream;
    private final int logicalIndex;
    private final List<Double> missing;
    private final List<String> missingStrings;
    String shortName;
    byte[] longName;
    int stringLength;
    int veryLongStringLength = -1;
    boolean isVeryLongStringSegment = false;
    Map<Double, byte[]> valueLabels;
    private byte[] label;
    private boolean hasMissingRange;
    private double missingMin;
    private double missingMax;

    SpssVariable(SpssInputStream inputStream, int position, int logicalIndex) throws IOException {
        this.inputStream = inputStream;
        this.logicalIndex = logicalIndex;
        this.positionInRecord = position;
        this.typeCode = inputStream.readInt();
        if (this.typeCode == 0) {
            this.numeric = true;
            this.stringLength = -1;
        } else {
            this.numeric = false;
            this.stringLength = this.typeCode;
        }
        int hasLabel = inputStream.readInt();
        int missingCode = inputStream.readInt();
        this.missing = new ArrayList<Double>();
        this.missingStrings = new ArrayList<String>();
        this.printFormat = new SpssVariableFormat(inputStream.readInt());
        this.writeFormat = new SpssVariableFormat(inputStream.readInt());
        byte[] shortNameBytes = inputStream.readBytes(8);
        this.shortName = new String(shortNameBytes, ASCII).trim();
        if (hasLabel == 1) {
            this.readLabel();
        }
        if (missingCode > 0) {
            for (int i = 0; i < missingCode; ++i) {
                if (this.numeric) {
                    this.missing.add(inputStream.readDouble());
                    continue;
                }
                this.missingStrings.add(new String(inputStream.readBytes(8)));
            }
        } else if (missingCode < 0) {
            this.hasMissingRange = true;
            this.missingMin = inputStream.readDouble();
            this.missingMax = inputStream.readDouble();
            if (missingCode == -3) {
                this.missing.add(inputStream.readDouble());
            }
        }
    }

    private void readLabel() throws IOException {
        int labelLength = this.inputStream.readInt();
        byte[] bytes = this.inputStream.readBytes(SpssInputStream.alignSize(labelLength, 4));
        this.label = new byte[labelLength];
        System.arraycopy(bytes, 0, this.label, 0, labelLength);
    }

    public boolean isMissing(double value) {
        if (this.hasMissingRange && this.missingMin <= value && value <= this.missingMax) {
            return true;
        }
        return this.missing.contains(value);
    }

    public String getVariableName() {
        if (this.longName != null) {
            return this.inputStream.stringFromBytes(this.longName);
        }
        return this.shortName;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public SpssVariableFormat getPrintFormat() {
        return this.printFormat;
    }

    public SpssVariableFormat getWriteFormat() {
        return this.writeFormat;
    }

    int getPositionInRecord() {
        return this.positionInRecord;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getVariableLabel() {
        return this.inputStream.stringFromBytes(this.label);
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isVeryLongString() {
        return this.veryLongStringLength > -1;
    }

    public boolean isVeryLongStringSegment() {
        return this.isVeryLongStringSegment;
    }

    public int getIndex() {
        return this.logicalIndex;
    }

    public boolean isHasMissingRange() {
        return this.hasMissingRange;
    }

    public double getMissingMin() {
        return this.missingMin;
    }

    public double getMissingMax() {
        return this.missingMax;
    }

    public List<Double> getMissing() {
        return this.missing;
    }

    public List<String> getMissingStrings() {
        return this.missingStrings;
    }

    public Map<Double, String> getValueLabels() {
        HashMap<Double, String> map = new HashMap<Double, String>();
        if (this.valueLabels != null) {
            for (Map.Entry<Double, byte[]> entry : this.valueLabels.entrySet()) {
                map.put(entry.getKey(), this.inputStream.stringFromBytes(entry.getValue()));
            }
        }
        return map;
    }
}

