/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss.lib;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

class SpssInputStream {
    private DataInputStream file;
    private boolean needToFlipBytes;
    private Charset charset = Charset.forName("Cp1252");

    public SpssInputStream(InputStream is) {
        this.file = new DataInputStream(is);
    }

    public SpssInputStream(InputStream is, Charset charset) {
        this.file = new DataInputStream(is);
        this.charset = charset;
    }

    public DataInputStream getFile() {
        return this.file;
    }

    public void setFile(DataInputStream file) {
        this.file = file;
    }

    public boolean isNeedToFlipBytes() {
        return this.needToFlipBytes;
    }

    public void setNeedToFlipBytes(boolean needToFlipBytes) {
        this.needToFlipBytes = needToFlipBytes;
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] buffer = new byte[count];
        this.getFile().readFully(buffer);
        return buffer;
    }

    public int readRawInt() throws IOException {
        return this.file.readInt();
    }

    public int readInt() throws IOException {
        int i = this.getFile().readInt();
        if (this.isNeedToFlipBytes()) {
            return Integer.reverseBytes(i);
        }
        return i;
    }

    public long readLong() throws IOException {
        long l = this.getFile().readLong();
        if (this.isNeedToFlipBytes()) {
            return Long.reverseBytes(l);
        }
        return l;
    }

    public double readDouble() throws IOException {
        double d = this.getFile().readDouble();
        if (this.isNeedToFlipBytes()) {
            long l = Double.doubleToRawLongBits(d);
            l = Long.reverseBytes(l);
            return Double.longBitsToDouble(l);
        }
        return d;
    }

    public int readUnsignedByte() throws IOException {
        return this.getFile().readUnsignedByte();
    }

    public void skipBytes(int count) throws IOException {
        this.readBytes(count);
    }

    public void setEncoding(String encoding) {
        this.charset = Charset.forName(encoding);
    }

    public String stringFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return SpssInputStream.trimZeros(new String(bytes, this.charset));
    }

    static String trimZeros(String str) {
        int pos = str.indexOf(0);
        return pos == -1 ? str : str.substring(0, pos);
    }

    static int alignSize(int i, int bytes) {
        int mod = i % bytes;
        if (mod == 0) {
            return i;
        }
        return i + (bytes - mod);
    }
}

