/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss.lib;

import crazydev.iccube.builder.datasource.spss.lib.CaseBuffer;
import crazydev.iccube.builder.datasource.spss.lib.CaseReader;
import crazydev.iccube.builder.datasource.spss.lib.MissingValuesHeader;
import crazydev.iccube.builder.datasource.spss.lib.SpssInputStream;
import crazydev.iccube.builder.datasource.spss.lib.SpssVariable;
import java.io.IOException;
import java.util.List;

class CompressedCaseReader
extends CaseReader {
    private static final int MIN_STORAGE_FLAG = 252;
    private static final int STRING_FLAG = 253;
    private static final int DOUBLE_FLAG = 253;
    private static final int WHITESPACE_FLAG = 254;
    private static final int SYSMIS_FLAG = 255;
    private static final int END_OF_BLOCK = 8;
    private final int[] flags = new int[8];
    private int flagIndex = 8;

    public CompressedCaseReader(SpssInputStream inputStream, List<SpssVariable> variables, MissingValuesHeader missingValues, int numCases, CaseBuffer currentRow) {
        super(inputStream, variables, missingValues, numCases, currentRow);
    }

    @Override
    public void restart() throws IOException {
        super.restart();
        this.flagIndex = 8;
    }

    private int readNextStorageFlag() throws IOException {
        if (this.flagIndex >= 8) {
            for (int i = 0; i != 8; ++i) {
                this.flags[i] = this.inputStream.readUnsignedByte();
            }
            this.flagIndex = 0;
        }
        return this.flags[this.flagIndex++];
    }

    @Override
    protected void readRow() throws IOException {
        int storageFlag = 0;
        for (SpssVariable var : this.variables) {
            if (var.isNumeric()) {
                while ((storageFlag = this.readNextStorageFlag()) == 0 && var.getIndex() == 0) {
                }
                if (storageFlag < 252) {
                    this.currentRow.set(var.getIndex(), storageFlag - 100);
                    continue;
                }
                if (storageFlag == 253) {
                    this.currentRow.set(var.getIndex(), this.inputStream.readDouble());
                    continue;
                }
                if (storageFlag != 255) continue;
                this.currentRow.setMissing(var.getIndex());
                continue;
            }
            StringBuilder buffer = new StringBuilder();
            int totalBytesRead = 0;
            while (true) {
                if ((storageFlag = this.readNextStorageFlag()) == 0 && var.getIndex() == 0) {
                    continue;
                }
                if (storageFlag == 253) {
                    buffer.append(this.inputStream.stringFromBytes(this.inputStream.readBytes(8)));
                } else if (storageFlag == 254) {
                    buffer.append("        ");
                }
                if ((totalBytesRead += 8) >= var.stringLength) break;
            }
            int paddingBytes = totalBytesRead - var.stringLength;
            int end = buffer.length() - paddingBytes;
            String strValue = buffer.substring(0, Math.max(0, end));
            String trimmedValue = strValue.trim();
            if (var.isVeryLongString() || var.isVeryLongStringSegment()) {
                int trailingSpaces = strValue.length() - trimmedValue.length();
                this.currentRow.setTrailingSpaces(var.getIndex(), trailingSpaces);
            }
            this.currentRow.set(var.getIndex(), trimmedValue);
        }
    }
}

