/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssConnection;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappers;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssTable;
import crazydev.iccube.builder.datasource.spss.lib.SpssDataFileReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderSpssRowReaderData
extends OlapBuilderAbstractTableRowReader<OlapBuilderSpssTable, OlapBuilderSpssConnection> {
    private Map<IOlapBuilderDataColumnDef, OlapBuilderSpssMappers> map;
    private SpssDataFileReader reader;

    public OlapBuilderSpssRowReaderData(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapBuilderSpssTable table, int maxRowCount) {
        super(context, connectionPool, maxRowCount, table, table.getName());
    }

    @Override
    public void doInit() {
        this.initConnection();
        this.reader = ((OlapBuilderSpssConnection)this.connection).getReader();
        this.map = new HashMap<IOlapBuilderDataColumnDef, OlapBuilderSpssMappers>();
        this.getTable().getAllColumns().forEach(col -> {
            OlapBuilderSpssMappers refTable = ((OlapBuilderSpssConnection)this.connection).getMapper(col.getName());
            if (refTable != null) {
                this.map.put((IOlapBuilderDataColumnDef)col, refTable);
            }
        });
    }

    @Override
    public boolean isRowSafe() {
        return false;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        try {
            if (!this.reader.readNextCase()) {
                return null;
            }
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
        }
        return columnDef -> {
            OlapBuilderSpssMappers refTable = this.map.get(columnDef);
            if (refTable == null) {
                return null;
            }
            Comparable<?> value = refTable.getValueForDataRow(this.reader);
            return value;
        };
    }
}

