/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss;

import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssDataSource;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappers;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappersOptions;
import crazydev.iccube.builder.datasource.spss.lib.SpssDataFileReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderSpssConnection
extends OlapBuilderAbstractConnection<OlapBuilderSpssDataSource> {
    public static final String DATA_TABLE_NAME = "# SPSS_DATA";
    private SpssDataFileReader reader;
    private InputStream stream;
    private OlapBuilderSpssMappers dataTable;
    private List<OlapBuilderSpssMappers> variableTables;
    private List<OlapBuilderSpssMappers> measureTables;

    public OlapBuilderSpssConnection(OlapBuilderSpssDataSource dataSource) {
        super(dataSource);
    }

    public SpssDataFileReader getReader() {
        return this.reader;
    }

    private SpssDataFileReader getSpssReader(OlapRuntimeContext context) {
        String fileName = ((OlapBuilderSpssDataSource)this.dataSource).getFileName();
        try {
            OlapFileSystem fs = context.getRootFileSystem();
            OlapFile trusted = fs.create(fileName);
            Charset encoding = ((OlapBuilderSpssDataSource)this.getDataSource()).getEncoding();
            this.stream = trusted.createInputStream();
            return new SpssDataFileReader(this.stream, encoding);
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage(), fileName});
        }
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        this.reader = this.getSpssReader(context);
        OlapBuilderSpssMappersOptions options = ((OlapBuilderSpssDataSource)this.dataSource).getMapperOptions();
        CdPair<List<OlapBuilderSpssMappers>, List<OlapBuilderSpssMappers>> res = OlapBuilderSpssMappers.builder(this.reader, options);
        this.variableTables = (List)res.fst;
        this.measureTables = (List)res.snd;
        this.dataTable = OlapBuilderSpssMappers.dataTable(this.variableTables, this.measureTables, DATA_TABLE_NAME, this.reader.getNumCases());
    }

    @Override
    protected void onClose() {
        IOUtils.closeQuietly((InputStream)this.stream);
        this.reader = null;
    }

    public List<String> discoverAllTablesNames(String filter) {
        if (this.reader == null) {
            return Collections.emptyList();
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(DATA_TABLE_NAME);
        String upperCaseFilter = filter == null ? null : filter.toUpperCase();
        this.variableTables.forEach(table -> {
            String tableName = table.getTableName();
            if (upperCaseFilter == null || tableName.toUpperCase().contains(upperCaseFilter)) {
                tableNames.add(tableName);
            }
        });
        return tableNames;
    }

    @Nullable
    public OlapBuilderSpssMappers getMapper(String tableName) {
        if (DATA_TABLE_NAME.equals(tableName)) {
            return this.dataTable;
        }
        OlapBuilderSpssMappers mapper = this.get(this.variableTables, tableName);
        if (mapper == null) {
            mapper = this.get(this.measureTables, tableName);
        }
        return mapper;
    }

    @Nullable
    public OlapBuilderSpssMappers getRefTable(String tableName) {
        if (DATA_TABLE_NAME.equals(tableName)) {
            return this.dataTable;
        }
        return this.get(this.variableTables, tableName);
    }

    private OlapBuilderSpssMappers get(List<OlapBuilderSpssMappers> variableTables, String tableName) {
        return variableTables.stream().filter(olapBuilderSpssTable -> olapBuilderSpssTable.getTableName().equals(tableName)).findFirst().orElse(null);
    }

    public List<OlapBuilderSpssMappers> getRefTables() {
        return this.variableTables;
    }

    public OlapBuilderSpssMappers getRefData() {
        return this.dataTable;
    }

    public List<OlapBuilderSpssMappers> getMeasures() {
        return this.measureTables;
    }
}

