/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.reader.cache;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.datasource.reader.cache.OlapBuilderCacheTableHelper;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCacheWriteTableRowReader
implements IOlapBuilderTableRowReader<IOlapBuilderConnection> {
    private final File cacheTableDirectory;
    private final IOlapBuilderTableRowReader underlying;
    @Nullable
    private DataOutputStream out;

    public OlapBuilderCacheWriteTableRowReader(OlapBuilderContext context, File cacheTableDirectory, IOlapBuilderTableRowReader underlying) {
        this.cacheTableDirectory = cacheTableDirectory;
        this.underlying = underlying;
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[table-cache] setup a writing-to-cache reader for table [" + underlying.getTableName() + "]"));
        }
    }

    @Override
    public String getName() {
        return "cache-write";
    }

    @Override
    public String getTableName() {
        return this.underlying.getTableName();
    }

    @Override
    public String getFullTableNameForEndUser() {
        return this.underlying.getFullTableNameForEndUser();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.underlying.getPartitionKey();
    }

    @Override
    public IOlapBuilderDataTableDef<IOlapBuilderConnection> getTable() {
        return this.underlying.getTable();
    }

    @Override
    public void init() {
        this.underlying.init();
        this.createStream();
    }

    @Override
    public boolean isRowSafe() {
        return this.underlying.isRowSafe();
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow nextRow() {
        IOlapBuilderTableRow row = this.underlying.nextRow();
        if (row != null) {
            this.writeRow(row);
        }
        return row;
    }

    @Override
    public int rowNb() {
        return this.underlying.rowNb();
    }

    @Override
    public void done() {
        this.underlying.done();
        this.closeStream();
    }

    private void createStream() {
        String filename = OlapBuilderCacheTableHelper.getFileName(this.getTable());
        File tableFile = new File(this.cacheTableDirectory, filename);
        if (tableFile.exists()) {
            OlapLoggers.BUILDER.error((Object)("[table-cache] unexpected exiting table-cache for table [" + this.getTableName() + "]"));
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_CREATE_FILE_ERROR, new Serializable[]{this.getTableName(), "existing-file"});
        }
        try {
            this.out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tableFile))));
            IOlapBuilderDataTableDef<IOlapBuilderConnection> table = this.getTable();
            List<IOlapBuilderDataColumnDef> selectedColumns = table.getActualSelectedColumns();
            int colCount = selectedColumns.size();
            this.out.writeInt(colCount);
            for (int ii = 0; ii < colCount; ++ii) {
                String colName = selectedColumns.get(ii).getName();
                this.out.writeUTF(colName);
            }
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[table-cache] could not create table-cache for table [" + this.getTableName() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_CREATE_FILE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
    }

    private void writeRow(IOlapBuilderTableRow row) {
        if (this.out == null) {
            return;
        }
        try {
            IOlapBuilderDataTableDef<IOlapBuilderConnection> table = this.getTable();
            List<IOlapBuilderDataColumnDef> selectedColumns = table.getActualSelectedColumns();
            for (IOlapBuilderDataColumnDef selectedColumn : selectedColumns) {
                Comparable nativeValue = row.getJavaNativeDataValue(selectedColumn);
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(nativeValue);
                serializer.write(this.out, nativeValue);
            }
            this.out.flush();
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[table-cache] could not write to the table-cache for table [" + this.getTableName() + "] [row:" + this.rowNumberForEndUser() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_WRITE_ERROR, new Serializable[]{this.getTableName(), this.rowNumberForEndUser(), ex.getMessage()});
        }
    }

    private void closeStream() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                OlapLoggers.BUILDER.error((Object)("[table-cache] could not properly flush/close the table-cache for table [" + this.getTableName() + "]"), (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_CLOSE_FILE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
            }
        }
    }
}

