/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.reader;

import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderDataTableFilters;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableFilteringRowReader<TABLE extends IOlapBuilderDataTableDef<CONNECTION>, CONNECTION extends IOlapBuilderConnection>
implements IOlapBuilderTableRowReader<CONNECTION> {
    private final IOlapBuilderTableRowReader underlying;
    private final List<IOlapBuilderDataColumnDef> underlyingColumns;
    private final OlapBuilderDataTableFilters filters;
    private int rowNumber;

    public OlapBuilderTableFilteringRowReader(IOlapBuilderTableRowReader underlying, OlapBuilderDataTableFilters filters) {
        this.underlying = underlying;
        this.underlyingColumns = underlying.getTable().getAllColumns();
        this.filters = filters;
    }

    @Override
    public IOlapBuilderDataTableDef<CONNECTION> getTable() {
        return this.underlying.getTable();
    }

    @Override
    public String getName() {
        return this.underlying.getName();
    }

    @Override
    public String getTableName() {
        return this.underlying.getTableName();
    }

    @Override
    public String getFullTableNameForEndUser() {
        return this.underlying.getFullTableNameForEndUser();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.underlying.getPartitionKey();
    }

    @Override
    public void init() {
        this.underlying.init();
        this.rowNumber = 1;
    }

    @Override
    public boolean isRowSafe() {
        return this.underlying.isRowSafe();
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow nextRow() {
        IOlapBuilderTableRow row;
        while ((row = this.underlying.nextRow()) != null && !this.filters.acceptRow(this.underlyingColumns, row)) {
        }
        if (row != null) {
            ++this.rowNumber;
        }
        return row;
    }

    @Override
    public int rowNb() {
        return this.rowNumber;
    }

    @Override
    public void done() {
        this.underlying.done();
    }
}

