/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.reader;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public abstract class OlapBuilderAbstractTableRowReader<TABLE extends IOlapBuilderDataTableDef<CONNECTION>, CONNECTION extends IOlapBuilderConnection>
implements IOlapBuilderTableRowReader<CONNECTION> {
    protected final OlapBuilderContext context;
    protected final OlapBuilderConnectionPool connectionPool;
    protected final int maxRowCount;
    protected final TABLE table;
    protected final String fullNameForEndUser;
    protected CONNECTION connection;
    private int maxRowCountWithH;
    private int rowNumber;
    private Function dateFormatter;
    private Function dateTimeFormatter;

    protected OlapBuilderAbstractTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, TABLE table, String fullNameForEndUser) {
        this.context = context;
        this.connectionPool = connectionPool;
        this.maxRowCount = maxRowCount == -1 && table != null ? table.getRowLimit() : maxRowCount;
        this.table = table;
        this.fullNameForEndUser = fullNameForEndUser;
    }

    public OlapBuilderAbstractTableRowReader(OlapBuilderAbstractTableRowReader<TABLE, CONNECTION> reader) {
        this.context = reader == null ? null : reader.context;
        this.connectionPool = reader == null ? null : reader.connectionPool;
        this.maxRowCount = reader == null ? -1 : reader.maxRowCount;
        this.table = reader == null ? null : reader.table;
        this.fullNameForEndUser = reader == null ? null : reader.fullNameForEndUser;
    }

    protected void extractStringToDateConverter(Locale stringConverterLocale, String stringDateConverter) {
        if (!StringUtils.isEmpty((CharSequence)stringDateConverter)) {
            String dateTimeFormat;
            String[] converters = stringDateConverter.split("_&_");
            String dateFormat = converters[0].trim();
            Locale locale = stringConverterLocale == null ? Locale.getDefault() : stringConverterLocale;
            Function function = this.dateFormatter = dateFormat.equalsIgnoreCase("epoch") ? this.fromEpoch() : new SimpleDateFormat(dateFormat, locale)::parse;
            this.dateTimeFormatter = converters.length > 1 ? ((dateTimeFormat = converters[1].trim()).equalsIgnoreCase("epoch") ? this.fromEpoch() : new SimpleDateFormat(StringUtils.isEmpty((CharSequence)dateTimeFormat) ? dateFormat : dateTimeFormat, locale)::parse) : this.dateFormatter;
        } else {
            this.dateFormatter = null;
            this.dateTimeFormatter = null;
        }
    }

    protected boolean hasStringToDate() {
        return this.dateFormatter != null;
    }

    protected Object parseStringToDate(IOlapBuilderDataColumnDef column, String value) {
        try {
            if (column.getType() == OlapBuilderInputType.DATE) {
                return this.dateFormatter.parse(value);
            }
            if (column.getType() == OlapBuilderInputType.DATETIME) {
                return this.dateTimeFormatter.parse(value);
            }
            return value;
        }
        catch (NumberFormatException | ParseException ex) {
            throw new OlapBuilderInputTypeConversionErrorException(column.getName(), value, ex);
        }
    }

    @NotNull
    private Function fromEpoch() {
        return text -> new LocalDate((long)(Double.parseDouble(text) * 1000.0), DateTimeZone.UTC);
    }

    @Override
    public IOlapBuilderDataTableDef<CONNECTION> getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return "full";
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public String getFullTableNameForEndUser() {
        return this.fullNameForEndUser;
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return null;
    }

    protected int numberOfHeaderRows() {
        return 0;
    }

    @Override
    public void init() {
        this.rowNumber = this.numberOfHeaderRows();
        this.maxRowCountWithH = this.maxRowCount == -1 ? -1 : this.maxRowCount + this.rowNumber;
        this.doInit();
    }

    public abstract void doInit();

    @Override
    public abstract boolean isRowSafe();

    @Override
    @Nullable
    public IOlapBuilderTableRow nextRow() {
        if (this.maxRowCountWithH != -1 && this.rowNumber >= this.maxRowCountWithH) {
            return null;
        }
        IOlapBuilderTableRow row = this.doNextRow();
        if (row == null) {
            return null;
        }
        ++this.rowNumber;
        return row;
    }

    @Nullable
    public abstract IOlapBuilderTableRow doNextRow();

    @Override
    public int rowNb() {
        return this.rowNumber;
    }

    @Override
    public void done() {
        this.connectionPool.releaseOpenedConnection(this.connection);
    }

    protected void initConnection() {
        if (this.connection != null) {
            this.connectionPool.releaseOpenedConnection(this.connection);
        }
        this.connection = this.connectionPool.getOrCreateOpenedConnection(this.context.asRuntimeContext(), this.table.getDataSource());
    }

    @FunctionalInterface
    public static interface Function {
        public Comparable parse(String var1) throws ParseException;
    }
}

