/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.json.base;

import com.google.gson.stream.JsonReader;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.json.base.IOlapBuilderJsonDataTable;
import crazydev.iccube.builder.datasource.json.base.OlapBuilderJsonBaseConnection;
import crazydev.iccube.builder.datasource.json.base.OlapBuilderJsonTableRowReader;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.gson.GsonTableColumnBuilder;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderJsonBaseTable<C extends OlapBuilderJsonBaseConnection>
extends OlapBuilderBaseDataTable<C>
implements IOlapBuilderJsonDataTable<C> {
    public OlapBuilderJsonBaseTable() {
    }

    public OlapBuilderJsonBaseTable(String tableName) {
        super(tableName);
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, C openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        JsonReader reader = this.getReaderForColumnDiscover(context, openedConnection);
        List<IOlapBuilderDataColumnDef> cols = GsonTableColumnBuilder.getColumns(reader, this.getDocRoot(), this::tagMatchesError, this.getColumnDiscoverRowsLimit());
        cols.sort(Comparator.comparing(IOlapBuilderDataColumnDef::isSelected).reversed().thenComparing(IOlapBuilderNamedDef::getName));
        return cols;
    }

    protected int getColumnDiscoverRowsLimit() {
        return -1;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, C connection, OlapBuilderErrorManager errorManager) {
        return this.discoverAllColumns(context, connection, errorManager);
    }

    protected JsonReader getReaderForColumnDiscover(OlapRuntimeContext context, C openedConnection) {
        return this.executeRequest(context, openedConnection, this.getColumnDiscoverRowsLimit()).get();
    }

    @Override
    protected IOlapBuilderTableRowReader<C> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderJsonTableRowReader(context, connectionPool, maxRowCount, this, this.getName());
    }

    @Override
    public abstract String[] getDocRoot();

    @Override
    public abstract Supplier<JsonReader> executeRequest(OlapRuntimeContext var1, C var2, int var3);

    @Override
    public boolean tagMatchesError(String s) {
        return false;
    }
}

