/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.json.base;

import com.google.gson.stream.JsonReader;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.json.base.IOlapBuilderJsonConnection;
import crazydev.iccube.builder.datasource.json.base.OlapBuilderJsonBaseDataSource;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderJsonBaseConnection<DS extends OlapBuilderJsonBaseDataSource>
extends OlapBuilderAbstractConnection<DS>
implements IOlapBuilderJsonConnection {
    protected CloseableHttpClient httpclient;

    public OlapBuilderJsonBaseConnection(DS dataSource) {
        super(dataSource);
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
    }

    @Override
    protected void onClose() {
        IOUtils.closeQuietly((Closeable)this.httpclient);
        this.httpclient = null;
    }

    public JsonReader executePost(URI uri, Consumer<HttpPost> requestModifier) {
        HttpPost clientRequest = new HttpPost(uri);
        requestModifier.accept(clientRequest);
        return this.executeClientRequest((HttpRequestBase)clientRequest, null);
    }

    public JsonReader executeGet(URI uri, Consumer<HttpGet> requestModifier) {
        return this.executeGet(uri, requestModifier, null);
    }

    public JsonReader executeGet(URI uri, Consumer<HttpGet> requestModifier, @Nullable Function<IOException, Boolean> ignoreError) {
        HttpGet clientRequest = new HttpGet(uri);
        requestModifier.accept(clientRequest);
        return this.executeClientRequest((HttpRequestBase)clientRequest, ignoreError);
    }

    public JsonReader executeClientRequest(HttpRequestBase clientRequest, @Nullable Function<IOException, Boolean> ignoreError) {
        try {
            CloseableHttpResponse httpResponse = this.httpclient.execute((HttpUriRequest)clientRequest);
            int status = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            if (status < 200 || status >= 300) {
                return this.onHttpRequestError(clientRequest.getURI().toString(), status, entity != null ? EntityUtils.toString((HttpEntity)entity) : "");
            }
            InputStream content = entity.getContent();
            if (content == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"Error connecting to " + clientRequest.getURI().toString() + ":Empty content"});
            }
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(content));
            return reader;
        }
        catch (IOException ex) {
            if (ignoreError != null && ignoreError.apply(ex).booleanValue()) {
                return null;
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getClass().getSimpleName(), ex.getMessage()});
        }
    }

    @NotNull
    protected JsonReader onHttpRequestError(String url, int status, String content) throws IOException {
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"Error connecting to " + url + ":" + content + " (" + status + ")"});
    }
}

