/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.collection.CdIComparableList;
import crazydev.common.utils.CdJdbcUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlParametersUtils;
import crazydev.iccube.builder.datasource.jdbc.IBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import java.lang.reflect.InvocationTargetException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

public abstract class OlapBuilderJdbcTypedDatasource {
    private static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW", "SYNONYM"};
    protected final OlapBuilderDriverType driverType;
    protected final String dbName;
    protected final Set<String> excludedSchemas;
    protected final String schemaName;

    public OlapBuilderJdbcTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        this(driverType, dbName, schemaName, null);
    }

    protected OlapBuilderJdbcTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName, String excludedSchemas) {
        this.driverType = driverType;
        this.dbName = CdXmlParametersUtils.replace((String)dbName);
        this.schemaName = CdXmlParametersUtils.replace((String)schemaName);
        this.excludedSchemas = excludedSchemas == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(CdXmlParametersUtils.replace((String)excludedSchemas).toLowerCase().split(";")));
    }

    public ResultSet getDbTables(DatabaseMetaData metaData, @Nullable String tableNamePattern) throws SQLException {
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaNameForMetaRetrieval();
        String[] types = this.getTableTypes();
        ResultSet rs = metaData.getTables(catalogName, schemaName, tableNamePattern, types);
        return rs;
    }

    protected String[] getTableTypes() {
        return TABLE_TYPES;
    }

    public ResultSet getDbColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaNameForMetaRetrieval();
        ResultSet rs = metaData.getColumns(catalogName, schemaName, tableName, null);
        return rs;
    }

    public String getTableNameForCreateTable(DatabaseMetaData meta, @Nullable String tableCatalog, @Nullable String tableSchema, String tableName) throws SQLException {
        return tableName;
    }

    public boolean isSchemaAccepted(String schemaName) {
        return schemaName == null || !this.excludedSchemas.contains(schemaName.toLowerCase());
    }

    @Nullable
    protected abstract String getCatalogName();

    @Nullable
    protected String getSchemaName() {
        return this.schemaName;
    }

    @Nullable
    protected String getSchemaNameForMetaRetrieval() {
        String sn = this.getSchemaName();
        return CdStringUtils.isNullOrBlank((String)sn) ? null : sn;
    }

    public abstract void onResultSetMetaData(IBuilderJdbcConnection var1, String var2, GetMetaDataProcessor var3) throws SQLException;

    protected String adaptTableName(DatabaseMetaData meta, String tableName) throws SQLException {
        return tableName;
    }

    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        String quoteString;
        name = isTable ? this.adaptTableName(meta, name) : name;
        if (!name.contains(quoteString = meta.getIdentifierQuoteString())) {
            if (meta.storesLowerCaseIdentifiers() && !name.equals(name.toLowerCase())) {
                return this.addQuoteToEntityName(name, quoteString);
            }
            if (meta.storesUpperCaseIdentifiers() && !name.equals(name.toUpperCase())) {
                return this.addQuoteToEntityName(name, quoteString);
            }
        }
        return name;
    }

    private String addQuoteToEntityName(String name, String quoteString) {
        return quoteString + name + quoteString;
    }

    public void afterDiscoverColumns(IBuilderJdbcConnection openedConnection) {
    }

    public int getDefaultFetchSize() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGetMetaData(IBuilderJdbcConnection conn, String sql, GetMetaDataProcessor processor, boolean executeQuery) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.createStatement(sql, 1);
            if (executeQuery) {
                stmt.execute();
            }
            ResultSetMetaData meta = stmt.getMetaData();
            processor.onValid(meta);
        }
        catch (Throwable throwable) {
            CdJdbcUtils.closeQuietly(stmt);
            throw throwable;
        }
        CdJdbcUtils.closeQuietly((Statement)stmt);
    }

    public boolean supportsAutoCommit() {
        return true;
    }

    public final void updateOrInsert(OlapBuilderJdbcConnection connection, OlapBuilderJdbcDataTable table, List<IOlapBuilderDataColumnDef> cacheKeyColumns, List<IOlapBuilderDataColumnDef> cacheValueColumns, Map<List<Comparable>, List<Comparable>> toInsert, Map<List<Comparable>, List<Comparable>> toUpdate, int batchMaxSize) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        DatabaseMetaData metaData = connection.getMetaData();
        String tableName = this.getEntityNameForSqlStatement(metaData, table.getName(), true);
        try (Connection writeConnection = connection.createWriteConnection();){
            this.doInsertOrUpdate(cacheKeyColumns, cacheValueColumns, toInsert, toUpdate, metaData, tableName, writeConnection, batchMaxSize);
            writeConnection.commit();
        }
    }

    protected void doInsertOrUpdate(List<IOlapBuilderDataColumnDef> cacheKeyColumns, List<IOlapBuilderDataColumnDef> cacheValueColumns, Map<List<Comparable>, List<Comparable>> toInsert, Map<List<Comparable>, List<Comparable>> toUpdate, DatabaseMetaData metaData, String tableName, Connection writeConnection, int batchMaxSize) throws SQLException {
        int j;
        int i;
        List<Comparable> valueValues;
        List<Comparable> keyValues;
        String statement;
        int columnSize = cacheKeyColumns.size() + cacheValueColumns.size();
        if (!toUpdate.isEmpty()) {
            String sqlValues = this.getAsSql(cacheValueColumns, metaData, " = ?", ", ");
            String sqlKey = this.getAsSql(cacheKeyColumns, metaData, " = ?", " AND ");
            statement = "UPDATE " + tableName + " SET " + sqlValues + " WHERE " + sqlKey;
            try (PreparedStatement updateStatement = writeConnection.prepareStatement(statement);){
                for (Map.Entry<List<Comparable>, List<Comparable>> entry : toUpdate.entrySet()) {
                    keyValues = entry.getKey();
                    valueValues = entry.getValue();
                    if (cacheKeyColumns.size() != keyValues.size()) {
                        throw new IndexOutOfBoundsException("Key Size mismatch " + cacheKeyColumns.size() + ", " + keyValues.size());
                    }
                    if (cacheValueColumns.size() != valueValues.size()) {
                        throw new IndexOutOfBoundsException("Value Size mismatch " + cacheValueColumns.size() + ", " + valueValues.size());
                    }
                    i = 1;
                    for (Comparable comparable : valueValues) {
                        OlapBuilderJdbcTypedDatasource.setValue(updateStatement, cacheValueColumns.get(i - 1), i++, comparable);
                    }
                    j = 0;
                    for (Comparable value3 : keyValues) {
                        OlapBuilderJdbcTypedDatasource.setValue(updateStatement, cacheKeyColumns.get(j++), i++, value3);
                    }
                    updateStatement.addBatch();
                    if (batchMaxSize <= 0 || i % batchMaxSize != 0) continue;
                    updateStatement.executeBatch();
                }
                updateStatement.executeBatch();
            }
        }
        if (!toInsert.isEmpty()) {
            String colNames = this.getAsSql(cacheKeyColumns, metaData, "", ", ") + ", " + this.getAsSql(cacheValueColumns, metaData, "", ", ");
            String sqlValues = String.join((CharSequence)", ", Collections.nCopies(columnSize, "?"));
            statement = "INSERT INTO " + tableName + " (" + colNames + ") VALUES (" + sqlValues + ")";
            try (PreparedStatement insertStatement = writeConnection.prepareStatement(statement);){
                for (Map.Entry<List<Comparable>, List<Comparable>> entry : toInsert.entrySet()) {
                    keyValues = entry.getKey();
                    valueValues = entry.getValue();
                    if (cacheKeyColumns.size() != keyValues.size()) {
                        throw new IndexOutOfBoundsException("Key Size mismatch " + cacheKeyColumns.size() + ", " + keyValues.size());
                    }
                    if (cacheValueColumns.size() != valueValues.size()) {
                        throw new IndexOutOfBoundsException("Value Size mismatch " + cacheValueColumns.size() + ", " + valueValues.size());
                    }
                    i = 1;
                    for (Comparable comparable : keyValues) {
                        OlapBuilderJdbcTypedDatasource.setValue(insertStatement, cacheKeyColumns.get(i - 1), i++, comparable);
                    }
                    j = 0;
                    for (Comparable value : valueValues) {
                        OlapBuilderJdbcTypedDatasource.setValue(insertStatement, cacheValueColumns.get(j++), i++, value);
                    }
                    insertStatement.addBatch();
                    if (batchMaxSize <= 0 || i % batchMaxSize != 0) continue;
                    insertStatement.executeBatch();
                }
                insertStatement.executeBatch();
            }
        }
    }

    private static void setValue(PreparedStatement statement, IOlapBuilderDataColumnDef col, int i, Comparable value) throws SQLException {
        if (value instanceof LocalDate) {
            java.util.Date javaDate = ((LocalDate)value).toDate();
            statement.setDate(i, new Date(javaDate.getTime()));
            return;
        }
        if (col.isArray() && value instanceof CdIComparableList) {
            Array valueAsArray = statement.getConnection().createArrayOf(col.getTableType(), ((CdIComparableList)value).toComparableArray().getArray());
            statement.setArray(i, valueAsArray);
        } else {
            statement.setObject(i, value);
        }
    }

    private String getAsSql(List<IOlapBuilderDataColumnDef> cacheValueColumns, DatabaseMetaData metaData, String endFix, String delimiter) throws SQLException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < cacheValueColumns.size(); ++i) {
            builder.append(i != 0 ? delimiter : "").append(this.getEntityNameForSqlStatement(metaData, cacheValueColumns.get(i).getName(), false)).append(endFix);
        }
        return builder.toString();
    }

    public void overrideParams(Properties params) {
    }

    public boolean isDiscoverColumnOnMetaSupported() {
        return true;
    }

    @FunctionalInterface
    public static interface GetMetaDataProcessor {
        public void onValid(ResultSetMetaData var1) throws SQLException;
    }
}

