/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.xml.CdXmlParametersUtils;
import crazydev.iccube.builder.datasource.jdbc.IBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcTrinoTypedDatasource
extends OlapBuilderJdbcTypedDatasource {
    protected static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW"};
    private final String catalogName;

    public OlapBuilderJdbcTrinoTypedDatasource(OlapBuilderDriverType driverType, String catalogName, String schemaName) {
        super(driverType, "?", schemaName);
        this.catalogName = CdXmlParametersUtils.replace((String)catalogName);
    }

    @Override
    protected String[] getTableTypes() {
        return TABLE_TYPES;
    }

    @Override
    @Nullable
    protected String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public void onResultSetMetaData(IBuilderJdbcConnection openedConnection, String sqlStatement, OlapBuilderJdbcTypedDatasource.GetMetaDataProcessor processor) throws SQLException {
        this.doGetMetaData(openedConnection, sqlStatement, processor, false);
    }

    @Override
    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        String quoteString;
        name = isTable ? this.adaptTableName(meta, name) : name;
        if (!name.contains(quoteString = meta.getIdentifierQuoteString())) {
            if (isTable) {
                if (meta.storesLowerCaseIdentifiers() && !name.equals(name.toLowerCase())) {
                    return this.addQuoteToEntityName(name, quoteString);
                }
                if (meta.storesUpperCaseIdentifiers() && !name.equals(name.toUpperCase())) {
                    return this.addQuoteToEntityName(name, quoteString);
                }
            } else {
                return this.addQuoteToEntityName(name, quoteString);
            }
        }
        return name;
    }

    private String addQuoteToEntityName(String name, String quoteString) {
        return quoteString + name + quoteString;
    }
}

