/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSqlServerLikeTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcSqlServerTypedDatasource
extends OlapBuilderJdbcSqlServerLikeTypedDatasource {
    public OlapBuilderJdbcSqlServerTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName);
    }

    @Override
    public String getTableNameForCreateTable(DatabaseMetaData meta, @Nullable String tableCatalog, @Nullable String tableSchema, String tableName) throws SQLException {
        if (tableName.contains(".")) {
            throw new CdShouldNotBeHereProgrammingException("SQL Server contains a table name with a dot : " + tableName);
        }
        if (tableSchema != null && !tableSchema.isEmpty()) {
            if (tableSchema.contains(".")) {
                throw new CdShouldNotBeHereProgrammingException("SQL Server contains a table schema with a dot  : " + tableSchema);
            }
            return tableSchema + "." + tableName;
        }
        return tableName;
    }

    @Override
    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        if (isTable) {
            return this.addQuoteToEntityName(name).replace(".", "].[");
        }
        return this.addQuoteToEntityName(name);
    }

    private String addQuoteToEntityName(String name) {
        name = name.replace("]", "]]");
        return "[" + name + "]";
    }
}

