/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSybaseTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class OlapBuilderJdbcSqlAnywhereTypedDatasource
extends OlapBuilderJdbcSybaseTypedDatasource {
    public static final String CATALOG_SEPARATOR = ".";

    public OlapBuilderJdbcSqlAnywhereTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName);
    }

    @Override
    protected String getCatalogName() {
        return "";
    }

    @Override
    protected String getCatalogSeparator(DatabaseMetaData meta) throws SQLException {
        return CATALOG_SEPARATOR;
    }

    @Override
    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        if (isTable) {
            return this.asTableNameForQuery(name);
        }
        return this.addQuotedChar(name);
    }

    protected String asTableNameForQuery(String tableName) throws SQLException {
        if (tableName.contains(" ") && tableName.contains(CATALOG_SEPARATOR)) {
            String[] names = tableName.split("\\.");
            return this.addQuotedChar(names[0]) + CATALOG_SEPARATOR + this.addQuotedChar(names[1]);
        }
        return this.addQuotedChar(tableName);
    }

    @NotNull
    private String addQuotedChar(String tableOrColName) {
        return "\"" + tableOrColName + "\"";
    }
}

