/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcMySQLTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class OlapBuilderJdbcSnowflakeTypedDatasource
extends OlapBuilderJdbcMySQLTypedDatasource {
    public OlapBuilderJdbcSnowflakeTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName);
    }

    @Override
    protected boolean isUsingBackticks() {
        return false;
    }

    @Override
    protected String adaptTableName(DatabaseMetaData meta, String tableName) throws SQLException {
        String sep = meta.getCatalogSeparator();
        return this.prepend(this.getCatalogName(), sep) + this.prepend(this.getSchemaName(), sep) + tableName;
    }

    @NotNull
    private String prepend(String name, String sep) {
        return CdStringUtils.isNotNullAndNotBlank((String)name) ? name + sep : "";
    }
}

