/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.IBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcSimbaBigQueryTypedDatasource
extends OlapBuilderJdbcTypedDatasource {
    private final String schemaName;

    public OlapBuilderJdbcSimbaBigQueryTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName);
        this.schemaName = schemaName;
    }

    @Override
    @Nullable
    protected String getCatalogName() {
        return null;
    }

    @Override
    @Nullable
    protected String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void onResultSetMetaData(IBuilderJdbcConnection openedConnection, String sqlStatement, OlapBuilderJdbcTypedDatasource.GetMetaDataProcessor processor) throws SQLException {
        this.doGetMetaData(openedConnection, sqlStatement, processor, true);
    }

    @Override
    public String getTableNameForCreateTable(DatabaseMetaData meta, @Nullable String tableCatalog, @Nullable String tableSchema, String tableName) throws SQLException {
        if (CdStringUtils.isNullOrBlank((String)this.schemaName) && CdStringUtils.isNotNullAndNotBlank((String)tableSchema)) {
            return tableSchema + "." + tableName;
        }
        return tableName;
    }

    @Override
    public ResultSet getDbColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        String[] pattern;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaNameForMetaRetrieval();
        if (tableName.contains(".") && (pattern = tableName.split("\\.")).length == 2) {
            schemaName = pattern[0];
            tableName = pattern[1];
        }
        ResultSet rs = metaData.getColumns(catalogName, schemaName, tableName, null);
        return rs;
    }

    @Override
    protected String adaptTableName(DatabaseMetaData meta, String tableName) {
        return tableName.contains(".") || CdStringUtils.isNullOrBlank((String)this.schemaName) ? tableName : this.schemaName + "." + tableName;
    }

    @Override
    public boolean supportsAutoCommit() {
        return false;
    }

    @Override
    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) {
        return name;
    }
}

