/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSqlServerLikeTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class OlapBuilderJdbcPostgresTypedDatasource
extends OlapBuilderJdbcSqlServerLikeTypedDatasource {
    public OlapBuilderJdbcPostgresTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName);
    }

    @Override
    protected String[] getTableTypes() {
        String[] typesS = super.getTableTypes();
        String[] types = new String[typesS.length + 1];
        System.arraycopy(typesS, 0, types, 0, typesS.length);
        types[typesS.length] = "MATERIALIZED VIEW";
        return types;
    }

    @Override
    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        String quoteString;
        name = isTable ? this.adaptTableName(meta, name) : name;
        if (!name.contains(quoteString = meta.getIdentifierQuoteString())) {
            if (isTable) {
                if (meta.storesLowerCaseIdentifiers() && !name.equals(name.toLowerCase())) {
                    return this.addQuoteToEntityName(name, quoteString);
                }
                if (meta.storesUpperCaseIdentifiers() && !name.equals(name.toUpperCase())) {
                    return this.addQuoteToEntityName(name, quoteString);
                }
            } else {
                return this.addQuoteToEntityName(name, quoteString);
            }
        }
        return name;
    }

    private String addQuoteToEntityName(String name, String quoteString) {
        int dotPosition = name.lastIndexOf(46);
        if (dotPosition != -1 && dotPosition < name.length() - 1) {
            return name.substring(0, dotPosition + 1) + quoteString + name.substring(dotPosition + 1) + quoteString;
        }
        return quoteString + name + quoteString;
    }
}

