/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTrinoTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcAWSAthenaTypedDatasource
extends OlapBuilderJdbcTrinoTypedDatasource {
    public OlapBuilderJdbcAWSAthenaTypedDatasource(OlapBuilderDriverType driverType, String catalogName, String schemaName) {
        super(driverType, catalogName, schemaName);
    }

    private String getAthenaCatalog() {
        return this.getCatalogName();
    }

    private String getAthenaDataBase() {
        return this.getSchemaName();
    }

    @Override
    public ResultSet getDbTables(DatabaseMetaData metaData, @Nullable String tableNamePattern) throws SQLException {
        String database = this.getAthenaDataBase();
        String sqlQuery = "SELECT table_catalog AS TABLE_CAT, table_schema as TABLE_SCHEM, table_name as TABLE_NAME, table_type as TABLE_TYPE FROM information_schema.tables " + (String)(CdStringUtils.isNullOrBlank((String)database) ? "" : "WHERE table_schema = '" + database + "'");
        Statement statement = metaData.getConnection().createStatement();
        return statement.executeQuery(sqlQuery);
    }

    @Override
    public void overrideParams(Properties params) {
        String catalog;
        super.overrideParams(params);
        String database = this.getAthenaDataBase();
        if (CdStringUtils.isNotNullAndNotBlank((String)database)) {
            params.setProperty("Database", database);
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(catalog = this.getAthenaCatalog()))) {
            params.setProperty("Catalog", catalog);
        }
    }

    @Override
    public boolean isDiscoverColumnOnMetaSupported() {
        return false;
    }
}

