/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTableRowReader;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcUnionTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.sql.SQLException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcUnionDataTablePartitionRowReader
extends OlapBuilderJdbcDataTableRowReader {
    protected final OlapBuilderJdbcUnionTablePartitionKey partitionKey;
    protected final String partitionSql;

    public OlapBuilderJdbcUnionDataTablePartitionRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapBuilderBaseJdbcDataTable table, IOlapBuilderTablePartitionKey partitionKey, String partitionSql) {
        super(context, connectionPool, -1, table);
        this.partitionKey = (OlapBuilderJdbcUnionTablePartitionKey)partitionKey;
        this.partitionSql = partitionSql;
    }

    @Override
    public void doInit() {
        super.doInit();
        try {
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - [partition : " + String.valueOf(this.partitionKey) + "] [fetchSize : " + ((OlapBuilderBaseJdbcDataTable)this.table).fetchSize + "] " + this.partitionSql));
            }
            this.statement = ((OlapBuilderJdbcConnection)this.connection).createStatement(this.partitionSql, ((OlapBuilderBaseJdbcDataTable)this.table).fetchSize);
            this.resultSet = this.statement.executeQuery();
        }
        catch (SQLException ex) {
            OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getTableName() + "] processing error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getFullTableNameForEndUser(), ex.getLocalizedMessage()});
        }
    }

    @Override
    public String getName() {
        return this.partitionKey.getName();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.partitionKey;
    }
}

