/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTableRowReader;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.sql.SQLException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcDataTablePartitionRowReader
extends OlapBuilderJdbcDataTableRowReader {
    protected final OlapBuilderJdbcTablePartitionKey partitionKey;

    public OlapBuilderJdbcDataTablePartitionRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapBuilderBaseJdbcDataTable table, IOlapBuilderTablePartitionKey partitionKey) {
        super(context, connectionPool, -1, table);
        this.partitionKey = (OlapBuilderJdbcTablePartitionKey)partitionKey;
    }

    @Override
    public void doInit() {
        super.doInit();
        try {
            if (!(this.table instanceof OlapBuilderJdbcDataTable)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_PARTITION_NOT_SUPPORTED, new Serializable[]{((OlapBuilderBaseJdbcDataTable)this.table).getName()});
            }
            OlapBuilderJdbcDataTable pTable = (OlapBuilderJdbcDataTable)this.table;
            String sql = pTable.createSelectStatementForPartitioning((OlapBuilderJdbcConnection)this.connection);
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - [partition : " + String.valueOf(this.partitionKey) + "] [fetchSize : " + ((OlapBuilderBaseJdbcDataTable)this.table).fetchSize + "] " + sql));
            }
            this.statement = ((OlapBuilderJdbcConnection)this.connection).createStatement(sql, ((OlapBuilderBaseJdbcDataTable)this.table).fetchSize);
            this.statement.setObject(1, this.partitionKey.getJdbcValue());
            this.resultSet = this.statement.executeQuery();
        }
        catch (SQLException ex) {
            OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getTableName() + "] processing error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getFullTableNameForEndUser(), ex.getLocalizedMessage()});
        }
    }

    @Override
    public String getName() {
        return this.partitionKey.getName();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.partitionKey;
    }
}

