/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.utils.CdJdbcUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTablePartitionRowReader;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderJdbcDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jdbcDatatable")
public class OlapBuilderJdbcDataTable
extends OlapBuilderBaseJdbcDataTable {
    public OlapBuilderJdbcDataTable() {
    }

    public OlapBuilderJdbcDataTable(String tableName, int defaultFetchSize) {
        super(tableName, defaultFetchSize);
    }

    public OlapBuilderJdbcDataTable(String tableName, List<IOlapBuilderDataColumnDef> columns) {
        super(tableName, columns);
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "JDBC Table";
    }

    @Override
    public boolean canCleanupNotUsedColumns() {
        return true;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderJdbcConnection openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        List<? extends IOlapBuilderDataColumnDef> columns = OlapBuilderJdbcDataTable.doDiscoverAllColumns(this.getName(), openedConnection, errorManager);
        return columns;
    }

    protected static List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(String tableName, OlapBuilderJdbcConnection openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        if (OlapLoggers.BUILDER.isDebugEnabled()) {
            OlapLoggers.BUILDER.debug((Object)("[DB] discovering columns for table [" + tableName + "] started"));
        }
        OlapBuilderJdbcDataSource dataSource = (OlapBuilderJdbcDataSource)openedConnection.getDataSource();
        return dataSource.discoverColumnForTable(tableName, openedConnection);
    }

    @Override
    protected List<IOlapBuilderTablePartitionKey> doGetPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        if (requestedPartitions != null) {
            return this.doGetPartitionKeysForLoadPartitions(context, connectionPool, requestedPartitions);
        }
        return this.doGetPartitionKeysFromJdbcRequest(context, connectionPool, null, null);
    }

    private List<IOlapBuilderTablePartitionKey> doGetPartitionKeysFromJdbcRequest(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable Object from, @Nullable Object to) {
        ArrayList<IOlapBuilderTablePartitionKey> arrayList;
        ArrayList<IOlapBuilderTablePartitionKey> partitionKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
        OlapBuilderJdbcConnection connection = (OlapBuilderJdbcConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), this.getDataSource());
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            int maxTablePartitionCount;
            String colName = this.getPartitioningColumnNameX();
            if (CdStringUtils.isNullOrBlank((String)colName)) {
                throw new RuntimeException("internal error : missing partition column name for table [" + this.getName() + "]");
            }
            IOlapBuilderDataColumnDef column = this.getSelectedColumn(colName);
            OlapBuilderInputType columnType = column.getType();
            String sqlColName = OlapBuilderJdbcDataTable.getJbcColumnName(connection, colName);
            String pct = this.getPartitioningColumnNameTableX();
            String pTable = CdStringUtils.isNullOrBlank((String)pct) ? this.getName() : pct;
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition keys table : " + pTable));
            }
            String sql = "SELECT DISTINCT " + sqlColName + " FROM " + connection.getTableNameForSqlStatement(pTable) + (String)(from != null ? " WHERE " + sqlColName + " BETWEEN ? AND ? " : "");
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition keys : " + sql));
            }
            statement = connection.createStatement(sql, this.fetchSize);
            if (from != null) {
                if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                    OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition keys : FROM " + String.valueOf(from) + " TO " + String.valueOf(to)));
                }
                statement.setObject(1, from);
                statement.setObject(2, to);
            }
            if ((maxTablePartitionCount = context.getMaxTablePartitionCount()) != -1) {
                statement.setMaxRows(maxTablePartitionCount);
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                if (resultSet.wasNull()) continue;
                Object partitionKey = resultSet.getObject(1);
                partitionKeys.add(OlapBuilderJdbcTablePartitionKey.createFromJdbc(columnType, partitionKey));
                if (!OlapLoggers.BUILDER_TABLE.isDebugEnabled()) continue;
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition key  : " + String.valueOf(partitionKey)));
            }
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition keys : " + partitionKeys.size()));
            }
            arrayList = partitionKeys;
        }
        catch (SQLException ex) {
            try {
                OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getName() + "] partition key processing error"), (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getName(), ex.getLocalizedMessage()});
            }
            catch (Throwable throwable) {
                CdJdbcUtils.closeQuietly(resultSet);
                CdJdbcUtils.closeQuietly(statement);
                connectionPool.releaseOpenedConnection(connection);
                throw throwable;
            }
        }
        CdJdbcUtils.closeQuietly((ResultSet)resultSet);
        CdJdbcUtils.closeQuietly((Statement)statement);
        connectionPool.releaseOpenedConnection(connection);
        return arrayList;
    }

    private List<IOlapBuilderTablePartitionKey> doGetPartitionKeysForLoadPartitions(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        List<IOlapBuilderTablePartitionKey> dbKeys;
        String columnName = this.getPartitioningColumnNameX();
        if (columnName == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_PARTITION_COLUMN_INVALID, new Serializable[]{this.getName(), "<null>"});
        }
        IOlapBuilderDataColumnDef column = this.getSelectedColumn(columnName);
        OlapBuilderInputType columnType = column.getType();
        ArrayList<IOlapBuilderTablePartitionKey> requestedPartitionKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
        for (String requestedPartition : requestedPartitions.getKeys()) {
            requestedPartitionKeys.add(OlapBuilderJdbcTablePartitionKey.createFromCommand(columnType, requestedPartition));
        }
        if (!requestedPartitions.isRange()) {
            dbKeys = requestedPartitionKeys;
        } else {
            OlapBuilderJdbcTablePartitionKey from = (OlapBuilderJdbcTablePartitionKey)requestedPartitionKeys.get(0);
            OlapBuilderJdbcTablePartitionKey to = (OlapBuilderJdbcTablePartitionKey)requestedPartitionKeys.get(1);
            dbKeys = this.doGetPartitionKeysFromJdbcRequest(context, connectionPool, from.getJdbcValue(), to.getJdbcValue());
        }
        ArrayList<IOlapBuilderTablePartitionKey> rKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
        for (IOlapBuilderTablePartitionKey dbKey : dbKeys) {
            rKeys.add(dbKey);
        }
        context.setRequestedTablePartitionKeys(this, rKeys);
        return dbKeys;
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderJdbcConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        return new OlapBuilderJdbcDataTablePartitionRowReader(context, connectionPool, this, partitionKey);
    }

    @Override
    protected String createSelectStatement(OlapBuilderJdbcConnection connection, boolean incrLoad) throws SQLException {
        StringBuilder builder = new StringBuilder("SELECT ");
        boolean first = true;
        for (IOlapBuilderDataColumnDef columnDef : this.getSelectedColumns()) {
            if (!columnDef.isForTableSelect()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append(OlapBuilderJdbcDataTable.getJbcColumnName(connection, columnDef));
            first = false;
        }
        if (this.getAllColumns().isEmpty()) {
            builder.append(" *");
        }
        builder.append(" FROM ").append(connection.getTableNameForSqlStatement(this.getName()));
        if (incrLoad) {
            builder.append(" ").append(this.getIncrementalWhereClause(connection));
        }
        String sql = builder.toString();
        return sql;
    }

    protected String createSelectStatementForPartitioning(OlapBuilderJdbcConnection connection) throws SQLException {
        StringBuilder builder = new StringBuilder("SELECT ");
        boolean first = true;
        for (IOlapBuilderDataColumnDef columnDef : this.getSelectedColumns()) {
            if (!columnDef.isForTableSelect()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append(OlapBuilderJdbcDataTable.getJbcColumnName(connection, columnDef));
            first = false;
        }
        String partitionColumn = this.getPartitioningColumnNameX();
        if (CdStringUtils.isNullOrBlank((String)partitionColumn)) {
            throw new RuntimeException("internal error : missing partition column name for table [" + this.getName() + "]");
        }
        builder.append(" FROM ").append(connection.getTableNameForSqlStatement(this.getName()));
        String sqlColName = OlapBuilderJdbcDataTable.getJbcColumnName(connection, partitionColumn);
        builder.append(" WHERE ").append(sqlColName).append(" = ?");
        String sql = builder.toString();
        return sql;
    }

    protected static String getJbcColumnName(OlapBuilderJdbcConnection connection, IOlapBuilderDataColumnDef columnDef) throws SQLException {
        return OlapBuilderJdbcDataTable.getJbcColumnName(connection, columnDef.getName());
    }

    protected static String getJbcColumnName(OlapBuilderJdbcConnection connection, String columnDefName) throws SQLException {
        return connection.getColumnNameForSqlStatement(columnDefName);
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderJdbcConnection>, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection>> getValidator() {
        return new OlapBuilderJdbcDataTableValidator();
    }

    @Override
    public void updateOrInsert(OlapRuntimeContext runtimeContext, List<IOlapBuilderDataColumnDef> cacheKeyColumns, List<IOlapBuilderDataColumnDef> cacheValueColumns, Map<List<Comparable>, List<Comparable>> toInsert, Map<List<Comparable>, List<Comparable>> toUpdate, int maxBatchSize) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        OlapBuilderJdbcDataSource ds = this.getTypedDataSource();
        try (OlapBuilderJdbcConnection connection = ds.createConnection(runtimeContext, false);){
            connection.open(runtimeContext);
            ds.getOrCreateTypedDataSource().updateOrInsert(connection, this, cacheKeyColumns, cacheValueColumns, toInsert, toUpdate, maxBatchSize);
        }
    }
}

