/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlEnum;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@XmlEnum
public enum OlapBuilderDriverType {
    AWS_REDSHIFT("com.amazon.redshift.jdbc42.Driver", "jdbc:redshift://serverName:portNumber/dbName", 5439, "jdbc:redshift://localhost/dbName", new HashSet<String>(Arrays.asList("dbName", "password", "port", "pwd", "user"))),
    DB2("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://serverName:portNumber/dbName", 50000, "jdbc:db2://", new HashSet<String>(Arrays.asList("password", "user"))),
    MYSQL("com.mysql.cj.jdbc.Driver", "jdbc:mysql://serverName:portNumber/dbName", 3306, "jdbc:mysql://", new HashSet<String>(Arrays.asList("dbname", "host", "password", "password1", "password2", "password3", "port", "user"))),
    ORACLE("oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@serverName:portNumber:dbName", 1521, "jdbc:oracle:thin:@", new HashSet<String>(Arrays.asList("password", "user"))),
    POSTGRES("org.postgresql.Driver", "jdbc:postgresql://serverName:portNumber/dbName", 5432, "jdbc:postgresql://", new HashSet<String>(Arrays.asList("password", "PGDBNAME", "PGHOST", "PGPORT", "user"))),
    SNOWFLAKE("", "jdbc:snowflake://serverName", 0, "jdbc:snowflake://"),
    SQLANYWHERE("", "jdbc:sqlanywhere:", 0, "jdbc:sqlanywhere:"),
    SQLSERVER("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://serverName:portNumber;databaseName=dbName;", 1433, "jdbc:sqlserver://", new HashSet<String>(Arrays.asList("password", "user"))),
    SYBASE_JTDS("net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sybase://serverName:portNumber/dbName", 7100, "jdbc:jtds:sybase://localhost", new HashSet<String>(Arrays.asList("PASSWORD", "USER"))),
    SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL("-", "-", 0, ""),
    TRINO("", "jdbc:trino://serverName:portNumber/catalog/schema", 8080, "jdbc:trino:", new HashSet<String>(Arrays.asList("password", "user"))),
    ATHENA("", "jdbc:trino://WorkGroup={workgroup};Region={region};OutputLocation={location}", 0, "jdbc:athena:", new HashSet<String>(Arrays.asList("password", "user")));

    private final String defaultPortNumber;
    private final String driverName;
    private final String url;
    private final String discoverUrl;
    @Nullable
    private final Set<String> excludedDriverProperties;

    private OlapBuilderDriverType(String driverName, String url, int defaultPortNumber, String discoverUrl) {
        this(driverName, url, defaultPortNumber, discoverUrl, null);
    }

    private OlapBuilderDriverType(String driverName, String url, @Nullable int defaultPortNumber, String discoverUrl, Set<String> excludedDriverProperties) {
        this.driverName = driverName;
        this.url = url;
        this.defaultPortNumber = String.valueOf(defaultPortNumber);
        this.discoverUrl = discoverUrl;
        this.excludedDriverProperties = excludedDriverProperties;
    }

    public String getDefinedUrl() {
        return this.url;
    }

    public String getDefaultPortNumber() {
        return this.defaultPortNumber;
    }

    public String getDriverName(String serverName) {
        if (this == SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL) {
            return serverName;
        }
        return this.driverName;
    }

    public static String blurUrl(String url) {
        if (CdStringUtils.isNullOrBlank((String)url)) {
            return url;
        }
        return url.replaceAll("password=.*", "...");
    }

    public String createURL(String url, String serverName, @Nullable String portNumber, @Nullable String catalog, @Nullable String schema, @Nullable String dbName) {
        if (this == SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL) {
            if (OlapLoggers.JDBC.isDebugEnabled()) {
                OlapLoggers.JDBC.debug((Object)("[JDBC] URL [" + OlapBuilderDriverType.blurUrl(url) + "] [serverName:" + serverName + "] [portNumber:" + portNumber + "] [catalog:" + catalog + "] [schema:" + schema + "] [dbName:" + OlapBuilderDriverType.blurUrl(dbName) + "]"));
            }
            return dbName;
        }
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] URL [" + OlapBuilderDriverType.blurUrl(url) + "] [serverName:" + serverName + "] [portNumber:" + portNumber + "] [catalog:" + catalog + "] [schema:" + schema + "] [dbName:" + dbName + "]"));
        }
        Object url_ = url;
        url_ = ((String)url_).replace("serverName", serverName);
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] URL w/ server [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
        }
        url_ = ((String)url_).replace("portNumber", CdStringUtils.isNullOrBlank((String)portNumber) ? this.defaultPortNumber : portNumber);
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] URL w/ port [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
        }
        if (catalog != null) {
            url_ = ((String)url_).replace("catalog", catalog);
            if (OlapLoggers.JDBC.isDebugEnabled()) {
                OlapLoggers.JDBC.debug((Object)("[JDBC] URL w/ catalog [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
            }
        }
        if (schema != null) {
            url_ = ((String)url_).replace("schema", schema);
            if (OlapLoggers.JDBC.isDebugEnabled()) {
                OlapLoggers.JDBC.debug((Object)("[JDBC] URL w/ schema [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
            }
        }
        if (dbName != null) {
            url_ = ((String)url_).replace("dbName", dbName);
            if (OlapLoggers.JDBC.isDebugEnabled()) {
                OlapLoggers.JDBC.debug((Object)("[JDBC] URL w/ DB [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
            }
        }
        if ((this == POSTGRES || ((String)url_).contains("jdbc:postgresql")) && !((String)url_).contains("OpenSourceSubProtocolOverride")) {
            try {
                URI uri = new URI((String)url_);
                String query = uri.getQuery();
                url_ = CdStringUtils.isNullOrBlank((String)query) ? (String)url_ + "?" : (String)url_ + "&";
                url_ = (String)url_ + "OpenSourceSubProtocolOverride=true";
                if (OlapLoggers.JDBC.isDebugEnabled()) {
                    OlapLoggers.JDBC.debug((Object)("[JDBC] Postgres URL fixed for Amazon Redshift [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
                }
            }
            catch (URISyntaxException ex) {
                OlapLoggers.JDBC.debug((Object)("[JDBC] Postgres URL cannot fix for Amazon Redshift [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"), (Throwable)ex);
            }
        }
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] URL completed [" + OlapBuilderDriverType.blurUrl((String)url_) + "]"));
        }
        return url_;
    }

    public boolean isMySql(String url) {
        if (this == MYSQL) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:mysql");
    }

    public boolean isHyperSQL(String url) {
        return url.toLowerCase().contains("jdbc:hsqldb");
    }

    public boolean isAWSRedshift(String url) {
        if (this == AWS_REDSHIFT) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:redshift");
    }

    public boolean isOracle(String url) {
        if (this == ORACLE) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:oracle");
    }

    public boolean isSnowflake(String url) {
        if (this == SNOWFLAKE) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:snowflake");
    }

    public boolean isAthena(String url) {
        if (this == ATHENA) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:athena") || url.toLowerCase().contains("jdbc:awsathena");
    }

    public boolean isTrino(String url) {
        if (this == TRINO) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:trino");
    }

    public boolean isSqlAnywhere(String url) {
        if (this == SQLANYWHERE) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:sqlanywhere");
    }

    public boolean isSqlServer(String url) {
        if (this == SQLSERVER) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:sqlserver");
    }

    public boolean isPostgres(String url) {
        if (this == POSTGRES) {
            return true;
        }
        return url.toLowerCase().contains("jdbc:postgresql");
    }

    public boolean isAccessJdk(String url) {
        return url.toLowerCase().contains("jdbc:odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)}");
    }

    public boolean isSybase(String url) {
        if (this == SYBASE_JTDS) {
            return true;
        }
        return url.toLowerCase().contains("sybase");
    }

    public boolean isDb2(String url) {
        if (this == DB2) {
            return true;
        }
        return url.toLowerCase().contains("db2");
    }

    public List<DriverPropertyInfo> getJdbcProperties(@Nullable String url) {
        try {
            String fixedURL = this == SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL ? (CdStringUtils.isNotNullAndNotBlank((String)url) ? url : this.discoverUrl) : this.discoverUrl;
            Driver driver = DriverManager.getDriver(fixedURL);
            DriverPropertyInfo[] properties = driver.getPropertyInfo(fixedURL, new Properties());
            List<DriverPropertyInfo> fixed = this.fixProperties(fixedURL, properties);
            fixed.sort((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.name, o2.name));
            return fixed;
        }
        catch (SQLException err) {
            OlapLoggers.BUILDER.error((Object)"[JDBC] could not retrieve the JDBC properties", (Throwable)err);
            return Collections.emptyList();
        }
    }

    private List<DriverPropertyInfo> fixProperties(String url, DriverPropertyInfo[] infos) {
        ArrayList<DriverPropertyInfo> fixed = new ArrayList<DriverPropertyInfo>();
        Set<String> excluded = this.excludedDriverProperties;
        if (this == SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL) {
            for (OlapBuilderDriverType olapBuilderDriverType : OlapBuilderDriverType.values()) {
                String[] parts;
                if (olapBuilderDriverType == SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL || (parts = olapBuilderDriverType.discoverUrl.split("(@)|(//)")).length <= 0 || !url.startsWith(parts[0])) continue;
                excluded = olapBuilderDriverType.excludedDriverProperties;
                break;
            }
        }
        for (DriverPropertyInfo driverPropertyInfo : infos) {
            if (excluded != null && excluded.contains(driverPropertyInfo.name)) continue;
            fixed.add(driverPropertyInfo);
        }
        return fixed;
    }
}

