/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.http;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

public class OlapBuilderHttpConnection<DATASOURCE extends OlapBuilderBaseDataSource>
extends OlapBuilderAbstractConnection<DATASOURCE> {
    public static final Logger LOGGER = OlapLoggers.BUILDER;
    final String baseUrl;
    CloseableHttpClient httpclient;
    private boolean serverRequestCloseAfterRequest;
    private CloseableHttpResponse response;
    private boolean forcedClosed;
    private final String httpHeader;

    public OlapBuilderHttpConnection(String baseUrl, String httpHeader) {
        super(null);
        this.baseUrl = baseUrl;
        this.httpHeader = httpHeader;
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        this.httpclient = HttpClients.createDefault();
    }

    @Override
    protected void onClose() {
        try {
            if (this.response != null) {
                this.response.close();
            }
            if (this.httpclient != null) {
                this.httpclient.close();
            }
        }
        catch (IOException ex) {
            LOGGER.warn((Object)"Impossible to close HTTP connection", (Throwable)ex);
        }
        finally {
            this.response = null;
            this.httpclient = null;
        }
    }

    public InputStream getInputStream(OlapRuntimeContext context, String path, String encoding) throws OlapBuilderErrorException {
        String uri = this.buildUri(this.baseUrl, path);
        HttpEntity entity = this.execute(context, uri);
        if (entity == null) {
            return IOUtils.toInputStream((String)"", (String)encoding);
        }
        try {
            return entity.getContent();
        }
        catch (UnsupportedEncodingException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CHAR_ENCODING_NOT_SUPPORTED, new Serializable[]{encoding});
        }
        catch (Exception ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HTTP_URI_EXCEPTION, new Serializable[]{uri, ex.getMessage()});
        }
    }

    public BufferedReader executeToReader(OlapRuntimeContext context, String path, String encoding) throws OlapBuilderErrorException {
        InputStream inputStream = this.getInputStream(context, path, encoding);
        try {
            return new BufferedReader(this, new InputStreamReader(inputStream, encoding)){
                final /* synthetic */ OlapBuilderHttpConnection this$0;
                {
                    OlapBuilderHttpConnection olapBuilderHttpConnection = this$0;
                    Objects.requireNonNull(olapBuilderHttpConnection);
                    this.this$0 = olapBuilderHttpConnection;
                    super(arg0);
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    this.this$0.forcedClosed = true;
                    this.this$0.onClose();
                }
            };
        }
        catch (UnsupportedEncodingException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CHAR_ENCODING_NOT_SUPPORTED, new Serializable[]{encoding});
        }
        catch (Exception ex) {
            String uri = this.buildUri(this.baseUrl, path);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HTTP_URI_EXCEPTION, new Serializable[]{uri, ex.getMessage()});
        }
    }

    private String buildUri(String baseUrl, String targetUri) {
        boolean needsSlash = !baseUrl.endsWith("/") && !targetUri.startsWith("/");
        return baseUrl + (needsSlash ? "/" : "") + targetUri;
    }

    public HttpEntity execute(OlapRuntimeContext context, String uri) throws OlapBuilderErrorException {
        if (this.serverRequestCloseAfterRequest) {
            this.onClose();
            this.onOpen(context);
        } else if (this.forcedClosed) {
            this.onOpen(context);
        }
        try {
            HttpGet httpget = new HttpGet(uri);
            this.addHeader((HttpRequestBase)httpget);
            this.response = this.httpclient.execute((HttpUriRequest)httpget);
            this.serverRequestCloseAfterRequest = this.hasCloseConnectionHeader((HttpResponse)this.response);
        }
        catch (NoHttpResponseException ex) {
            if (this.serverRequestCloseAfterRequest) {
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.HTTP_URI_EXCEPTION, new Serializable[]{uri, ex.getMessage()});
            }
            this.serverRequestCloseAfterRequest = true;
            return this.execute(context, uri);
        }
        catch (Exception ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.HTTP_URI_EXCEPTION, new Serializable[]{uri, ex.getMessage()});
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HTTP_URI_WRONG_STATUS_CODE, new Serializable[]{uri, Integer.valueOf(this.response.getStatusLine().getStatusCode()), this.response.getStatusLine().getReasonPhrase()});
        }
        return this.response.getEntity();
    }

    protected void addHeader(HttpRequestBase request) {
        OlapBuilderHttpConnection.addHeader((HttpMessage)request, this.httpHeader);
    }

    private boolean hasCloseConnectionHeader(HttpResponse response) {
        Header[] headers = response.getHeaders("Connection");
        return headers != null && headers.length >= 1 && headers[0].getValue().contains("close");
    }

    public static void addHeader(HttpMessage httpGetOrPost, String httpLoginHeader) {
        if (!CdStringUtils.isNullOrBlank((String)httpLoginHeader)) {
            String[] lines = httpLoginHeader.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String[] params;
                String line = lines[i].trim();
                if (CdStringUtils.isNullOrBlank((String)line) || line.startsWith("#") || (params = line.split("=")).length < 2) continue;
                String name = params[0].trim();
                String value = params[1].trim();
                if (CdStringUtils.isNullOrBlank((String)name)) continue;
                httpGetOrPost.addHeader(name, value);
            }
        }
    }
}

