/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.http;

import crazydev.iccube.builder.datasource.http.OlapBuilderHttpConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class OlapBuilderHttpBaseAuthenticationConnection<DATASOURCE extends OlapBuilderBaseDataSource>
extends OlapBuilderHttpConnection<DATASOURCE> {
    public static final Logger LOGGER = OlapLoggers.BUILDER;
    private final String user;
    private final String pwd;

    public OlapBuilderHttpBaseAuthenticationConnection(String baseUrl, String user, String pwd, String httpHeader) {
        super(baseUrl, httpHeader);
        this.user = user;
        this.pwd = pwd;
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        try {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.pwd);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.httpclient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
            URI ur = new URI(this.baseUrl);
            HttpGet httpGet = new HttpGet(ur);
            this.addHeader((HttpRequestBase)httpGet);
            CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                HttpEntity entity = response.getEntity();
                String content = entity != null ? EntityUtils.toString((HttpEntity)entity) : "";
                this.onClose();
                this.onHttpRequestError(this.baseUrl, statusCode, content);
            }
        }
        catch (IOException | URISyntaxException ex) {
            this.onClose();
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    @NotNull
    protected void onHttpRequestError(String url, int status, String content) {
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"Error connecting to " + url + ":" + content + " (" + status + ")"});
    }
}

