/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file.json;

import crazydev.common.exception.programming.CdNotImplementedProgrammingException;
import crazydev.iccube.builder.common.OlapAbstractFileSystem;
import crazydev.iccube.builder.datasource.file.OlapBuilderAbstractFileDataSource;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderFileJsonDataTable;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderHttpJsonDataTable;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderJsonConnection;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderMultiFileJsonDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jsonDS")
public class OlapBuilderJsonDataSource
extends OlapBuilderAbstractFileDataSource<OlapBuilderJsonConnection> {
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES_HTTP = Arrays.asList(OlapBuilderHttpJsonDataTable.class);
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderMultiFileJsonDataTable.class);

    public OlapBuilderJsonDataSource() {
    }

    public OlapBuilderJsonDataSource(String directory) {
        this((File)null, directory);
    }

    public OlapBuilderJsonDataSource(@Nullable File xmlFile, String directory) {
        super(xmlFile, directory);
    }

    @Override
    protected String getReportDataSourceType() {
        return "json";
    }

    @Override
    protected String getReportDataSourceTypeCaption() {
        return "Json";
    }

    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return this.isHttp() ? CREATED_TABLE_TYPES_HTTP : null;
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderJsonConnection> createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderFileJsonDataTable(tableName);
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderJsonConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        if (OlapBuilderMultiFileJsonDataTable.class.equals(tableType)) {
            throw new CdNotImplementedProgrammingException();
        }
        if (!OlapBuilderHttpJsonDataTable.class.equals(tableType)) {
            throw new RuntimeException("internal error : unexpected table type [" + (tableType != null ? tableType.getSimpleName() : "n/a") + "]");
        }
        OlapBuilderHttpJsonDataTable table = new OlapBuilderHttpJsonDataTable();
        return table;
    }

    @Override
    protected OlapBuilderJsonConnection createConnection(OlapAbstractFileSystem fs) {
        return new OlapBuilderJsonConnection(this, fs);
    }
}

