/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file.json;

import com.google.gson.stream.JsonReader;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.file.json.OlapBuilderJsonConnection;
import crazydev.iccube.builder.datasource.json.base.IOlapBuilderJsonDataTable;
import crazydev.iccube.builder.datasource.json.base.OlapBuilderJsonTableRowReader;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.gson.GsonTableColumnBuilder;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderBaseJsonDataTable
extends OlapBuilderBaseDataTable<OlapBuilderJsonConnection>
implements IOlapBuilderJsonDataTable<OlapBuilderJsonConnection> {
    public static final CdProperty JSON_ROOT = new CdReadWriteProperty(OlapBuilderBaseJsonDataTable.class, "jsonRoot");
    public static final CdProperty ERROR_MATCHER = new CdReadWriteProperty(OlapBuilderBaseJsonDataTable.class, "errorMatcher");
    public static final CdProperty ENCODING = new CdReadWriteProperty(OlapBuilderBaseJsonDataTable.class, "encoding");
    public static final CdProperty URL_PATH = new CdReadWriteProperty(OlapBuilderBaseJsonDataTable.class, "urlPath");
    public static final CdProperty COLUMN_DISCOVER_ROWS_LIMIT = new CdReadWriteProperty(OlapBuilderBaseJsonDataTable.class, "columnDiscoverRowsLimit");
    public static final CdProperty PROTOTYPE = new CdReadWriteProperty(OlapBuilderBaseJsonDataTable.class, "jsonPrototype"){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    @XmlAttribute
    private String urlPath;
    @XmlAttribute
    private String jsonRoot;
    @XmlAttribute
    private String errorMatcher;
    @XmlAttribute
    private String encoding = "UTF8";
    @XmlAttribute
    private int columnDiscoverRowsLimit = 5;
    @XmlAttribute
    private String jsonPrototype;

    public OlapBuilderBaseJsonDataTable() {
    }

    public OlapBuilderBaseJsonDataTable(String tableName) {
        super(tableName);
        this.urlPath = tableName;
    }

    @Override
    public boolean isNameReadOnly() {
        return false;
    }

    @Override
    public String[] getDocRoot() {
        return CdStringUtils.isNullOrBlank((String)this.jsonRoot) ? new String[]{} : this.jsonRoot.split("\\.");
    }

    @Override
    public boolean tagMatchesError(String jsonFieldName) {
        return CdStringUtils.isNotNullAndNotBlank((String)this.errorMatcher) && this.errorMatcher.equals(jsonFieldName);
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderJsonConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderJsonTableRowReader(context, connectionPool, maxRowCount, this, this.getName());
    }

    public String getEncoding() {
        return CdStringUtils.isNullOrBlank((String)this.encoding) ? "UTF8" : this.encoding;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderJsonConnection openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        JsonReader reader = this.getReaderForColumnDiscover(context, openedConnection);
        List<IOlapBuilderDataColumnDef> cols = GsonTableColumnBuilder.getColumns(reader, this.getDocRoot(), this::tagMatchesError, this.columnDiscoverRowsLimit);
        cols.sort(Comparator.comparing(IOlapBuilderDataColumnDef::isSelected).reversed().thenComparing(IOlapBuilderNamedDef::getName));
        return cols;
    }

    @Override
    public Supplier<JsonReader> executeRequest(OlapRuntimeContext context, OlapBuilderJsonConnection connection, int columnDiscoverRowsLimit) {
        LinkedList<JsonReader> queue = new LinkedList<JsonReader>();
        queue.add(connection.getJsonReader(context, this));
        return queue::poll;
    }

    private JsonReader getReaderForColumnDiscover(OlapRuntimeContext context, OlapBuilderJsonConnection openedConnection) {
        if (CdStringUtils.isNullOrBlank((String)this.jsonPrototype)) {
            return this.executeRequest(context, openedConnection, this.columnDiscoverRowsLimit).get();
        }
        return new JsonReader((Reader)new StringReader(this.jsonPrototype));
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderJsonConnection connection, OlapBuilderErrorManager errorManager) {
        return this.discoverAllColumns(context, connection, errorManager);
    }

    public String getUrlPath() {
        return CdStringUtils.isNullOrBlank((String)this.urlPath) ? this.getName() : this.urlPath;
    }
}

