/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.utils.CdCsvUtils;
import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineScanner;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.text.StringTokenizer;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderReaderLineScanner
extends OlapBuilderLineScanner {
    protected final CdLineReader reader;
    @Nullable
    protected final String commentMarker;
    @Nullable
    protected final String columnSeparatorPattern;
    protected final char columnSeparatorChar;
    protected int lineNumber;

    public OlapBuilderReaderLineScanner(String tableName, CdLineReader reader, @Nullable String commentMarker, String columnSeparator) {
        super(tableName);
        this.reader = reader;
        this.commentMarker = commentMarker;
        String unescaped = CdCsvUtils.unescapeJava((String)columnSeparator);
        if (unescaped.length() == 1) {
            this.columnSeparatorChar = unescaped.charAt(0);
            this.columnSeparatorPattern = null;
        } else {
            this.columnSeparatorPattern = Pattern.quote(unescaped);
            this.columnSeparatorChar = '\u0000';
        }
    }

    @Override
    @Nullable
    public String[] nextLine() {
        try {
            String line;
            while ((line = this.readLine()) != null && (this.commentMarker != null && !this.commentMarker.isEmpty() && line.startsWith(this.commentMarker) || line.trim().isEmpty())) {
            }
            return this.toFields(line);
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LINE_TABLE_IO_ERROR, new Serializable[]{this.tableName, Integer.valueOf(this.getLineNumber()), ex.getMessage()});
        }
    }

    @Nullable
    protected String[] toFields(@Nullable String line) {
        if (line == null) {
            return null;
        }
        if (this.columnSeparatorPattern != null) {
            return this.toFieldsFromPattern(line);
        }
        return this.toFieldsFromChar(line);
    }

    @Nullable
    protected String[] toFieldsFromChar(String line) {
        StringTokenizer tokens = new StringTokenizer(line, this.columnSeparatorChar).setIgnoreEmptyTokens(false);
        String[] fields = tokens.getTokenArray();
        return fields;
    }

    @Nullable
    protected String[] toFieldsFromPattern(String line) {
        String[] fields = line.split(this.columnSeparatorPattern);
        return fields;
    }

    @Nullable
    protected String readLine() throws IOException {
        String line = this.reader.readLine();
        ++this.lineNumber;
        return line;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void closeQuietly() {
        this.reader.closeQuietly();
    }

    @Override
    public String getCurrentFileName() {
        return this.reader.getCurrentFileName();
    }
}

