/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.common.IOlapBuilderLineReaderTable;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRow;
import crazydev.iccube.builder.datasource.file.IOlapBuilderBaseLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseFileDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineScanner;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderLineDataTableRowReader<CONNECTION extends OlapBuilderAbstractConnection>
extends OlapBuilderAbstractTableRowReader<IOlapBuilderBaseLineDataTable<CONNECTION>, CONNECTION> {
    public static final String ROW_NUM_COLUMN_NAME = "ic3-RowNum";
    public static final String ROW_FILENAME_COLUMN_NAME = "ic3-FileName";
    public static final String ROW_PARTITION_COLUMN_NAME = "ic3-Partition";
    private NumberFormat numberFormatter;
    private OlapBuilderLineScanner scanner;
    private String arraySeparator;
    private boolean checkColumnSize;

    public OlapBuilderLineDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, IOlapBuilderBaseLineDataTable<CONNECTION> table, String fullNameForEndUser) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    @Override
    protected int numberOfHeaderRows() {
        return ((IOlapBuilderBaseLineDataTable)this.table).isWithHeader() ? 1 : 0;
    }

    @Override
    public String getFullTableNameForEndUser() {
        if (this.scanner != null && this.table instanceof OlapBuilderBaseFileDataTable && !((OlapBuilderBaseFileDataTable)this.table).isSingleFile()) {
            return super.getFullTableNameForEndUser() + "::" + this.scanner.getCurrentFileName();
        }
        return super.getFullTableNameForEndUser();
    }

    @Override
    public void doInit() {
        this.initConnection();
        this.checkColumnSize = this.table instanceof IOlapBuilderLineReaderTable ? ((IOlapBuilderLineReaderTable)((Object)this.table)).checkColumnSize() : false;
        String stringDateConverter = ((IOlapBuilderBaseLineDataTable)this.table).getStringDateConverter();
        Locale stringConverterLocale = ((IOlapBuilderBaseLineDataTable)this.table).getStringConverterLocale();
        this.extractStringToDateConverter(stringConverterLocale, stringDateConverter);
        this.numberFormatter = stringConverterLocale != null ? NumberFormat.getInstance(stringConverterLocale) : null;
        this.arraySeparator = ((IOlapBuilderBaseLineDataTable)this.table).getArrayValueSeparator();
        try {
            this.scanner = ((IOlapBuilderBaseLineDataTable)this.table).createLineScanner((OlapBuilderAbstractConnection)this.connection, this.createLineReader());
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER_TABLE.error((Object)"Table scanner error", (Throwable)ex);
            String tableFullName = this.getFullTableNameForEndUser();
            OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.LINE_TABLE_READER_ERROR, new Serializable[]{tableFullName, ex.getMessage()});
            throw new OlapBuilderErrorException((Throwable)ex, error);
        }
        try {
            if (((IOlapBuilderBaseLineDataTable)this.table).isWithHeader()) {
                this.scanner.nextLine();
            }
        }
        catch (RuntimeException ex) {
            this.scanner.closeQuietly();
            OlapLoggers.BUILDER_TABLE.error((Object)"Table scanner (header) error", (Throwable)ex);
            String tableFullName = this.getFullTableNameForEndUser();
            OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.LINE_TABLE_HEADER_ERROR, new Serializable[]{tableFullName, ex.getMessage()});
            throw new OlapBuilderErrorException((Throwable)ex, error);
        }
    }

    CdLineReader createLineReader() {
        return ((IOlapBuilderBaseLineDataTable)this.table).createLineReader(this.context.asRuntimeContext(), (OlapBuilderAbstractConnection)this.connection);
    }

    @Override
    public boolean isRowSafe() {
        return true;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        String[] line = this.scanner.nextLine();
        if (line == null) {
            return null;
        }
        return this.createTableRow(line, this.scanner.getLineNumber());
    }

    @Override
    public void done() {
        if (this.scanner != null) {
            this.scanner.closeQuietly();
        }
        super.done();
    }

    protected OlapBuilderTableRow createTableRow(String[] row, int lineNumber) {
        List<IOlapBuilderDataColumnDef> columns = this.getTable().getAllColumns();
        Object[] values = new Object[columns.size()];
        int count = 0;
        int hasRowNumColumn = 0;
        if (((IOlapBuilderBaseLineDataTable)this.table).addRowNumberColumn() && columns.get(hasRowNumColumn).getName().equals(ROW_NUM_COLUMN_NAME)) {
            values[hasRowNumColumn++] = lineNumber;
        }
        if (((IOlapBuilderBaseLineDataTable)this.table).addRowFileNameColumn() && columns.get(hasRowNumColumn).getName().equals(ROW_FILENAME_COLUMN_NAME)) {
            values[hasRowNumColumn++] = this.scanner.getCurrentFileName();
        }
        if (((IOlapBuilderBaseLineDataTable)this.table).hasTablePartitioning() && columns.get(hasRowNumColumn).getName().equals(ROW_PARTITION_COLUMN_NAME)) {
            values[hasRowNumColumn++] = this.getPartitioningValue(this.scanner.getCurrentFileName());
        }
        if (this.checkColumnSize && hasRowNumColumn + row.length > values.length) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_NOT_CORRECT_NUMBER_OF_COLUMNS, Integer.valueOf(values.length), Integer.valueOf(hasRowNumColumn + row.length));
        }
        int rowLength = Math.min(row.length, values.length - hasRowNumColumn);
        while (count < rowLength) {
            IOlapBuilderDataColumnDef column = columns.get(count + hasRowNumColumn);
            if (column.isSelected()) {
                String value;
                String rowRawValue = row[count];
                String string = value = ((IOlapBuilderBaseLineDataTable)this.table).isTrimStrings() ? StringUtils.trim((String)rowRawValue) : rowRawValue;
                if (((IOlapBuilderBaseLineDataTable)this.table).removeQuotesInRowReader()) {
                    value = CdStringUtils.removeQuotes((String)value);
                }
                if (column.getDecorationType() == OlapBuilderColumnDecorationType.ARRAY) {
                    if ((value = value.trim()).length() == 0 || "[]".equals(value)) {
                        values[column.getIndex()] = null;
                    } else {
                        if (value.charAt(0) == '[') {
                            value = value.replace('[', ' ').replace(']', ' ');
                        }
                        String[] arrayValues = value.split(this.arraySeparator);
                        Object[] processed = new Object[arrayValues.length];
                        boolean hasNull = false;
                        for (int i = 0; i < arrayValues.length; ++i) {
                            Object arrayValue = this.preProcessColumnValue(column, arrayValues[i].trim());
                            hasNull |= arrayValue == null;
                            processed[i] = arrayValue;
                        }
                        if (hasNull) {
                            A[] trimmed = Arrays.stream(processed).filter(Objects::nonNull).toArray(Object[]::new);
                            values[column.getIndex()] = trimmed.length == 0 ? null : trimmed;
                        } else {
                            values[column.getIndex()] = processed;
                        }
                    }
                } else {
                    values[column.getIndex()] = this.preProcessColumnValue(column, value);
                }
            }
            ++count;
        }
        return new OlapBuilderTableRow(values);
    }

    private Object preProcessColumnValue(IOlapBuilderDataColumnDef column, String value) {
        Object colValue;
        if (StringUtils.isEmpty((CharSequence)value)) {
            colValue = value;
        } else if (this.hasStringToDate() && column.getType().isDateType()) {
            colValue = this.parseStringToDate(column, value);
        } else if (this.numberFormatter != null && column.getType().isNumber()) {
            Object number;
            try {
                number = this.numberFormatter.parse(value);
            }
            catch (ParseException ex) {
                number = value;
            }
            colValue = number;
        } else {
            colValue = value;
        }
        return colValue;
    }

    Object getPartitioningValue(String currentFileName) {
        return ((IOlapBuilderBaseLineDataTable)this.table).calculatePartition(currentFileName);
    }
}

