/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdLineReader;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.file.IOlapBuilderBaseLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineDataTableRowReader;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineScanner;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.goodies.headerdef.column.OlapBuilderColumnsDefinitionParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseLineDataTable<CONNECTION extends OlapBuilderAbstractConnection>
extends OlapBuilderBaseDataTable<CONNECTION>
implements IOlapBuilderBaseLineDataTable<CONNECTION> {
    public static final CdProperty STRING_DATE_CONVERTER = new CdReadWriteProperty(OlapBuilderBaseLineDataTable.class, "stringDateConverter");
    public static final CdProperty STRING_CONVERTER_LOCALE = new CdReadWriteProperty(OlapBuilderBaseLineDataTable.class, "stringConverterLocale");
    public static final CdProperty TRIM_STRINGS = new CdReadWriteProperty(OlapBuilderBaseLineDataTable.class, "trimStrings");
    public static final CdProperty ADD_ROW_NUMBER = new CdReadWriteProperty(OlapBuilderBaseLineDataTable.class, "addRowNumber");
    @XmlElement(required=false)
    protected boolean addRowNumber = false;
    @XmlElement(required=false)
    private String stringDateConverter;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="stringDateConverterLocale")
    private Locale stringConverterLocale;
    @XmlElement(required=false)
    private boolean trimStrings = true;

    protected OlapBuilderBaseLineDataTable() {
    }

    public OlapBuilderBaseLineDataTable(String tableName) {
        super(tableName);
    }

    public void buildColumnsFromHeader(OlapRuntimeContext context, CONNECTION connection, OlapBuilderErrorManager errorManager) {
        List<IOlapBuilderDataColumnDef> columns = this.discoverAllColumns(context, connection, errorManager);
        this.resetColumns(columns);
    }

    @Override
    public boolean isColumnPositionRelevant() {
        return true;
    }

    @Override
    public boolean addRowFileNameColumn() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, CONNECTION openedConnection, OlapBuilderErrorManager errorManager) {
        block8: {
            if (!this.isWithHeader()) {
                return Collections.emptyList();
            }
            OlapBuilderLineScanner scanner = null;
            try {
                scanner = this.createLineScanner(openedConnection, this.createLineReader(context, openedConnection));
                String[] headerNames = scanner.nextLine();
                if (headerNames == null) {
                    errorManager.addError(OlapBuilderErrorCode.EMPTY_HEADER, new Serializable[]{this.getName()});
                    break block8;
                }
                List<IOlapBuilderDataColumnDef> list = OlapBuilderColumnsDefinitionParser.parse(headerNames, this.addRowNumber, this.addRowFileNameColumn(), this.removeQuotesInRowReader(), this.shouldCreatePartitionColumn());
                return list;
            }
            catch (OlapBuilderErrorException ex) {
                errorManager.addError(ex.getError());
            }
            finally {
                if (scanner != null) {
                    scanner.closeQuietly();
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, CONNECTION connection, OlapBuilderErrorManager errorManager) {
        if (!this.isWithHeader()) {
            return new ArrayList<IOlapBuilderDataColumnDef>(this.getAllColumns());
        }
        return this.discoverAllColumns(context, connection, errorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOlapBuilderTableRowReader<CONNECTION> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        OlapBuilderAbstractConnection connection = (OlapBuilderAbstractConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), this.getDataSource());
        try {
            String fullNameForEndUser = this.getFullNameForEndUser(context.asRuntimeContext(), connection);
            OlapBuilderLineDataTableRowReader olapBuilderLineDataTableRowReader = new OlapBuilderLineDataTableRowReader(context, connectionPool, maxRowCount, this, fullNameForEndUser);
            return olapBuilderLineDataTableRowReader;
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }

    @Override
    public abstract OlapBuilderLineScanner createLineScanner(CONNECTION var1, CdLineReader var2);

    @Override
    public abstract CdLineReader createLineReader(OlapRuntimeContext var1, CONNECTION var2);

    protected abstract String getFullNameForEndUser(OlapRuntimeContext var1, CONNECTION var2);

    @Nullable
    public abstract String getCommentMarker();

    public abstract String getColumnSeparator();

    @Override
    public abstract boolean isWithHeader();

    @Override
    public boolean removeQuotesInRowReader() {
        return false;
    }

    boolean shouldCreatePartitionColumn() {
        return false;
    }

    @Override
    public Object calculatePartition(String currentFileName) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public String getStringDateConverter() {
        return this.stringDateConverter;
    }

    public void setStringDateConverter(String stringDateConverter) {
        this.stringDateConverter = stringDateConverter;
    }

    @Override
    public Locale getStringConverterLocale() {
        return this.stringConverterLocale;
    }

    public void setStringConverterLocale(Locale stringConverterLocale) {
        this.stringConverterLocale = stringConverterLocale;
    }

    @Override
    public boolean isTrimStrings() {
        return this.trimStrings;
    }

    @Override
    public boolean addRowNumberColumn() {
        return this.addRowNumber;
    }
}

