/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.security.CdPassword;
import crazydev.common.xml.CdPasswordXmlAdapter;
import crazydev.iccube.builder.common.OlapAbstractFileSystem;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.validation.OlapBuilderAbstractFileDataSourceValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizardSteps;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderAbstractFileDataSource<C extends OlapBuilderDirectoryConnection>
extends OlapBuilderBaseDataSource<C> {
    public static final CdProperty DIRECTORY = new CdReadWriteProperty(OlapBuilderAbstractFileDataSource.class, "directory");
    public static final CdProperty CHECK_COLUMN_SIZE = new CdReadWriteProperty(OlapBuilderAbstractFileDataSource.class, "checkColumnSize");
    public static final CdProperty HEADER = new CdReadWriteProperty(OlapBuilderAbstractFileDataSource.class, "httpLoginHeader");
    public static final CdProperty BASIC_PWD = new CdReadWriteProperty(OlapBuilderAbstractFileDataSource.class, "password");
    public static final CdProperty BASIC_USER = new CdReadWriteProperty(OlapBuilderAbstractFileDataSource.class, "user");
    @XmlAttribute(name="directory", required=true)
    private String directory;
    @XmlAttribute(name="checkColumnSize")
    private boolean checkColumnSize;
    @XmlAttribute
    private String user;
    @XmlJavaTypeAdapter(value=CdPasswordXmlAdapter.class)
    @XmlAttribute
    private CdPassword password;
    @XmlAttribute
    private String httpLoginHeader;

    public OlapBuilderAbstractFileDataSource() {
    }

    public OlapBuilderAbstractFileDataSource(@Nullable File xmlFile, String directory) {
        super(directory);
        this.directory = directory;
        this.setXmlFile(xmlFile);
    }

    @Override
    public UxBuilderDataSourceTypeGroupId getUxGroupId() {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupFiles;
    }

    protected boolean isHttp() {
        return this.directory != null && (this.directory.startsWith("http://") || this.directory.startsWith("https://"));
    }

    @Override
    public C createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        OlapFileSystem fs = context.getRootFileSystem();
        String dir = fs.evalPropertyForCubesLocation(this.directory);
        OlapAbstractFileSystem fileSystem = OlapAbstractFileSystem.createOlapSecureLocalFileSystem(dir, this.user, this.password != null ? this.password.clear : null, this.httpLoginHeader);
        return this.createConnection(fileSystem);
    }

    @NotNull
    protected C createConnection(OlapAbstractFileSystem fs) {
        return (C)new OlapBuilderDirectoryConnection<OlapBuilderAbstractFileDataSource>(this, fs);
    }

    @Override
    public boolean isDiscoverTablesSupported() {
        return !this.isHttp();
    }

    @Override
    public List<String> discoverAllTablesNames(OlapBuilderDirectoryConnection openedConnection, boolean filterSystemSchemas, @Nullable String filter) {
        ArrayList<String> dataTables = new ArrayList<String>();
        List<String> fileNames = openedConnection.listLocalFileNames(name -> this.acceptTableNameForDiscoverTableNames(filter, name));
        for (String fileName : fileNames) {
            dataTables.add(fileName);
        }
        return dataTables;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean checkColumnSize() {
        return this.checkColumnSize;
    }

    public void setCheckColumnSize(boolean checkColumnSize) {
        this.checkColumnSize = checkColumnSize;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderDataSource> getValidator() {
        return new OlapBuilderAbstractFileDataSourceValidator();
    }

    @Override
    public boolean acceptCachedTable() {
        return this.isHttp();
    }

    @Override
    public boolean hasNoTyping() {
        return true;
    }

    @Override
    protected UxBuilderDataSourceType createUxType() {
        String id = this.getTypeId();
        return new UxBuilderDataSourceType(id, this.getUxTypeImage(), () -> new UxBuilderCreateTypedDataSourceWizard(this, id, this.createUxCreateWizardSteps()){
            {
                Objects.requireNonNull(this$0);
                super(dataSourceTypeId, steps);
            }

            @Override
            public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
                UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                OlapBuilderAbstractFileDataSource props = (OlapBuilderAbstractFileDataSource)((UxBuilderWizardStep)this.steps.get(1)).getModel();
                props.setNameAndDescription(name.getName(), name.getDescription());
                try (IOlapBuilderConnection conn = null;){
                    conn = props.createConnection(context, true);
                    conn.openForCheckConnection(context);
                    UxBuilderWizardValidation uxBuilderWizardValidation = new UxBuilderWizardValidation(activeStep);
                    return uxBuilderWizardValidation;
                }
            }
        });
    }

    @Override
    protected List<UxBuilderWizardStep> createUxCreateWizardSteps() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateDataSourceWizardSteps.name());
        steps.add(UxBuilderCreateDataSourceWizardSteps.propsExclude(true, this.createEmptyDataSource(), NAME, DESCRIPTION));
        return steps;
    }
}

