/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdStringUtils;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCSVReader
implements Closeable {
    public static final int DEFAULT_SKIP_LINES = 0;
    protected final CdLineReader br;
    private final CSVParser parser;
    private final int skipLines;
    protected int lineNumber;
    private boolean hasNext = true;
    private boolean linesSkipped;

    public OlapBuilderCSVReader(CdLineReader reader) {
        this.br = reader;
        this.parser = new CSVParser();
        this.skipLines = 0;
    }

    public OlapBuilderCSVReader(CdLineReader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this.br = reader;
        this.skipLines = line;
        CSVParserBuilder builder = new CSVParserBuilder();
        this.parser = builder.withSeparator(separator).withQuoteChar(quotechar).withEscapeChar(escape).withStrictQuotes(strictQuotes).withIgnoreLeadingWhiteSpace(ignoreLeadingWhiteSpace).build();
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        do {
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            if (result == null) {
                result = r;
                continue;
            }
            String[] t = new String[result.length + r.length];
            System.arraycopy(result, 0, t, 0, result.length);
            System.arraycopy(r, 0, t, result.length, r.length);
            result = t;
        } while (this.parser.isPending());
        return result;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (!this.linesSkipped) {
            for (int ii = 0; ii < this.skipLines; ++ii) {
                this.skipLine();
            }
            this.linesSkipped = true;
        }
        if ((nextLine = this.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    protected void skipLine() throws IOException {
        this.br.readLine();
        ++this.lineNumber;
    }

    @Nullable
    protected String readLine() throws IOException {
        String line;
        do {
            line = this.br.readLine();
            ++this.lineNumber;
        } while (line != null && CdStringUtils.isNullOrBlank((String)line));
        return line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public String getCurrentFileName() {
        return this.br.getCurrentFileName();
    }
}

